package lu.tudor.santec.gecamed.billing.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Act;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;


/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: DefaultActSorter.java,v $
 * <br>Revision 1.2  2013-04-23 11:16:56  ferring
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2013-04-23 09:00:18  ferring
 * <br>Suffixes only applied to technical acts
 * <br>
 */

public class DefaultActSorter implements Comparator<Act>, Serializable
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private static DefaultActSorter	instance;
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public int compare (Act a1, Act a2)
	{
		int 	comparison;
		
		
        if (a1 == null && a2 == null) 
        	return 0;
        else if (a1 == null) 
        	return 1;
        else if (a2 == null) 
            return -1;
		
//		System.out.println(a1.getOrderNo() + ". " + a1.getCode());
//		System.out.println(a2.getOrderNo() + ". " + a2.getCode());
        
        comparison	= compareObject(a1.getPerformedDay(), a2.getPerformedDay());
        
//    	if (comparison != 0)
//    		return comparison;
//    	
//    	comparison	= compareObject(a1.getOrderNo(), a2.getOrderNo());
    	
    	if (comparison != 0)
    		return comparison;
    	
    	comparison	= compareObject(a1.getCode(), a1.getCode());
    	if (comparison != 0)
    		return comparison;
    	
    	comparison	= compareObject(a1.getCode()+a1.getSuffixes(), a2.getCode()+a2.getSuffixes());
    	
    	return comparison;
	}
	
	
	/**
	 * This compares 2 objects and checks on null values before comparing
	 * @param o1
	 * @param o2
	 * @return
	 */
	private <T> int compareObject (Comparable<T> o1, T o2)
	{
		if (o1 == null && o2 == null)
			return 0;
		else if (o1 == null)
			return -1;
		else if (o2 == null)
			return 1;
		else
			return o1.compareTo(o2);
	}
	
	
	public static TreeSet<Act> sort (Collection<Act> acts)
	{
		TreeSet<Act>	sortedActs	= new TreeSet<Act>(getInstance());
		
		
		sortedActs.addAll(acts);
		
		DefaultActSorter.printActOrder(sortedActs, "DefaultActSorter (sorted)");
		
		return sortedActs;
	}
	
	
	public static DefaultActSorter getInstance ()
	{
		if (instance == null)
			instance = new DefaultActSorter();
		
		return instance;
	}
	
	
	public static void printActOrder (Collection<Act> acts, String info)
	{
//		System.out.println("==========");
//		System.out.println(info);
//		System.out.println("----------");
//		for (Act a : acts)
//			System.out.println(a.getOrderNo() + ". " + a.getCode());
//		System.out.println("----------");
	}
}
