package lu.tudor.santec.gecamed.billing.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;


public class InvoiceReportField implements Serializable
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long serialVersionUID = 1L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private Invoice beanInvoice;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public InvoiceReportField (Invoice invoice)
	{
		this.beanInvoice = invoice;
	}
	
	
	public static Collection<InvoiceReportField> createFields (Collection<Invoice> invoices)
	{
		Collection<InvoiceReportField> fields = new ArrayList<InvoiceReportField>(invoices.size());
		for (Invoice invoice : invoices)
		{
			fields.add(new InvoiceReportField(invoice));
		}
		
		return fields;
	}
	
	
	
	/* ======================================== */
	// 		NEW BEAN FIELD
	/* ======================================== */
	
	public Invoice getBeanInvoice ()
	{
		return this.beanInvoice;
	}
	
	
	
	/* ======================================== */
	// 		OLD FIELDS
	/* ======================================== */
	
	public String getInvoiceNumber ()
	{
		return beanInvoice.getInvoiceNumber();
	}
	
	
	public String getFormatedDate ()
	{
		return beanInvoice.getFormatedDate();
	}
	
	
	public Double getAmount ()
	{
		return beanInvoice.getAmount();
	}
	
	
	public Double getPayment ()
	{
		return beanInvoice.getPayment();
	}
	
	
	public Double getBalance ()
	{
		return beanInvoice.getBalance();
	}
	
	
	public String getFormatedReminderDate ()
	{
		return beanInvoice.getFormatedReminderDate();
	}
}
