package lu.tudor.santec.gecamed.billing.utils;

import java.io.Serializable;
import java.util.Date;

public class TimeSpan implements Serializable {
	private static final long serialVersionUID = 1L;
	
	private Date m_Start;
	private Date m_End;
	
	public TimeSpan (Date p_Start, Date p_End)
		{
		this.m_Start = p_Start;
		this.m_End = p_End;
		}
	
	public Date getStartDate ()
		{
		return m_Start;
		}
	
	public Date getEndDate ()
		{
		return m_End;
		}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((m_End == null) ? 0 : m_End.hashCode());
		result = prime * result + ((m_Start == null) ? 0 : m_Start.hashCode());
		return result;
	}

	
	@Override
	public boolean equals(Object p_Object) 
		{
		Date l_Date;
		
		if (p_Object instanceof Date)
			{
			l_Date = (Date) p_Object;
			if (l_Date != null
					&&(	m_Start == null
					|| 	l_Date.after(m_Start))
					&&(	m_End == null
					|| 	l_Date.before(m_End)))
				 return true;
			else return false;
			}
		else return super.equals(p_Object);
		}
}