/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.cara.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Author: Johannes Hermen Tudor/Santec
 */

@javax.persistence.NamedQueries({

	@javax.persistence.NamedQuery(name=CaraImage.findImageByID,
		query="SELECT OBJECT(o) FROM CaraImage o WHERE o.studyInstUID = :imageID"),
	@javax.persistence.NamedQuery(name=CaraImage.getImageNrForID,
		query="SELECT COUNT(o.id) FROM CaraImage o WHERE o.studyInstUID = :imageID)"),
	@javax.persistence.NamedQuery(name=CaraImage.findThumbByID,
		query="SELECT o.thumbnail FROM CaraImage o WHERE o.studyInstUID = :imageID)"),
	@javax.persistence.NamedQuery(name=CaraImage.findInfoByID,
		query="SELECT o.size, o.rows, o.cols FROM CaraImage o WHERE o.studyInstUID = :imageID)")	
		})

@Entity
@Table(name="image", schema="cara")
public class CaraImage extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;

	public static final String findImageByID = "findImageByID";
	
	public static final String findThumbByID = "findThumbByID";
	
	public static final String getImageNrForID = "getImageNrForID";

	public static final String findInfoByID = "findInfoByID";
	
	private byte[]	data;
	
	private byte[]	thumbnail;
	
	private String mediaStorageSOPInstUID;
	
	private String studyInstUID;
	
	private String seriesInstUID;
	
	private String sopInstUID;
	
	private String imageNumber;
	
	private String size;
	
	private String cols;
	
	private String rows;
	
	

	/**
	 * @return the data
	 */
	@Column(name="data")
	public byte[] getData() {
		return data;
	}

	/**
	 * @param data the data to set
	 */
	public void setData(byte[] data) {
		this.data = data;
	}

	/**
	 * @return the imageNumber
	 */
	@Column(name="image_number")
	public String getImageNumber() {
		return imageNumber;
	}

	/**
	 * @param imageNumber the imageNumber to set
	 */
	public void setImageNumber(String imageNumber) {
		this.imageNumber = imageNumber;
	}

	/**
	 * @return the mediaStorageSOPInstUID
	 */
	@Column(name="media_storage_sop_inst_uid")
	public String getMediaStorageSOPInstUID() {
		return mediaStorageSOPInstUID;
	}

	/**
	 * @param mediaStorageSOPInstUID the mediaStorageSOPInstUID to set
	 */
	public void setMediaStorageSOPInstUID(String mediaStorageSOPInstUID) {
		this.mediaStorageSOPInstUID = mediaStorageSOPInstUID;
	}

	/**
	 * @return the seriesInstUID
	 */
	@Column(name="series_inst_uid")
	public String getSeriesInstUID() {
		return seriesInstUID;
	}

	/**
	 * @param seriesInstUID the seriesInstUID to set
	 */
	public void setSeriesInstUID(String seriesInstUID) {
		this.seriesInstUID = seriesInstUID;
	}

	/**
	 * @return the sopInstUID
	 */
	@Column(name="sop_inst_uid")
	public String getSopInstUID() {
		return sopInstUID;
	}

	/**
	 * @param sopInstUID the sopInstUID to set
	 */
	public void setSopInstUID(String sopInstUID) {
		this.sopInstUID = sopInstUID;
	}

	/**
	 * @return the studyInstUID
	 */
	@Column(name="study_inst_uid")
	public String getStudyInstUID() {
		return studyInstUID;
	}

	/**
	 * @param studyInstUID the studyInstUID to set
	 */
	public void setStudyInstUID(String studyInstUID) {
		this.studyInstUID = studyInstUID;
	}

	/**
	 * @return the thumbnail
	 */
	@Column(name="thumbnail")
	public byte[] getThumbnail() {
		return thumbnail;
	}

	/**
	 * @param thumbnail the thumbnail to set
	 */
	public void setThumbnail(byte[] thumbnail) {
		this.thumbnail = thumbnail;
	}

	/**
	 * @return the cols
	 */
	@Column(name="cols")
	public String getCols() {
		return cols;
	}

	/**
	 * @param cols the cols to set
	 */
	public void setCols(String cols) {
		this.cols = cols;
	}

	/**
	 * @return the rows
	 */
	@Column(name="rows")
	public String getRows() {
		return rows;
	}

	/**
	 * @param rows the rows to set
	 */
	public void setRows(String rows) {
		this.rows = rows;
	}

	/**
	 * @return the size
	 */
	@Column(name="size")
	public String getSize() {
		return size;
	}

	/**
	 * @param size the size to set
	 */
	public void setSize(String size) {
		this.size = size;
	}

}
