/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.cara.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Author: Johannes Hermen Tudor/Santec
 */

@javax.persistence.NamedQueries({

	@javax.persistence.NamedQuery(name=MedicalInfo.findMedicalInfoByPatientID,
		query="SELECT OBJECT(o) FROM MedicalInfo o WHERE o.patientID = :patientID")
		})

@Entity
@Table(name="medical_info", schema="cara")
public class MedicalInfo extends GECAMedEntityBean implements Serializable {

	public static final String findMedicalInfoByPatientID  = "findMedicalInfoByPatientID";	
	private static final long serialVersionUID = 1L;

	private Integer patientID;
	private String allergies;
	private String drugContraindictions;
	private String implants;

	/**
	 * @return Returns the code.
	 */
	@javax.persistence.Column(name = "allergies")
	public String getAllergies() {
		return allergies;
	}

	/**
	 * @param code The code to set.
	 */
	public void setAllergies(String code) {
		this.allergies = code;
	}

	/**
	 * @return Returns the name.
	 */
	@javax.persistence.Column(name = "drug_contraindictions")
	public String getDrugContraindictions() {
		return drugContraindictions;
	}

	/**
	 * @param name The name to set.
	 */
	public void setDrugContraindictions(String name) {
		this.drugContraindictions = name;
	}


	/**
	 * @return the implants
	 */
	@javax.persistence.Column(name = "implants")
	public String getImplants() {
		return implants;
	}

	/**
	 * @param implants the implants to set
	 */
	public void setImplants(String implants) {
		this.implants = implants;
	}

	/**
	 * @return the patientID
	 */
	@javax.persistence.Column(name = "patient_id")
	public Integer getPatientID() {
		return patientID;
	}

	/**
	 * @param patientID the patientID to set
	 */
	public void setPatientID(Integer patientID) {
		this.patientID = patientID;
	}

}
