package lu.tudor.santec.gecamed.core.ejb.entity.beans;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * @author ferring
 * 
 * This class is needed to store all auto completion templates
 */
@Entity
@Table(name="autocompletion", schema="core")
@NamedQueries ({
	@NamedQuery(name=Autocompletion.GET_ALL_COMPLETIONS,
			query = "SELECT OBJECT(o) FROM Autocompletion o"),
			
	@NamedQuery(name=Autocompletion.GET_COMPLETIONS_BY_CONTEXT, 
			query = "SELECT OBJECT(o) FROM Autocompletion o " +
					"WHERE o.context = :context"),
					
	@NamedQuery(name=Autocompletion.GET_COMPLETIONS_BY_CONTEXT_AND_ID, 
			query = "SELECT OBJECT(o) FROM Autocompletion o " +
					"WHERE o.context = :context " +
					"AND (" +
					"     o.userId is null" +
					"  OR o.userId = :userId" +
					")"
//					+ "ORDER BY o.inputText, o.replacementText ASC"
					),
					
	@NamedQuery(name=Autocompletion.GET_SINGLE_COMPLETION,
			query = "SELECT OBJECT(o) FROM Autocompletion o " +
					"WHERE o.context = :context " +
					"AND (" +
					"     o.userId is null " +
					"  OR o.userId = :userId" +
					")" +
					"AND o.inputText = :inputText " +
					"AND o.replacementText = :replacementText"),
					
	@NamedQuery(name=Autocompletion.SEARCH_COMPLETIONS, 
			query = "SELECT OBJECT(o) FROM Autocompletion o " +
					"WHERE o.context = :context " +
					"AND (" +
					"     o.userId is null" +
					"  OR o.userId = :userId" +
					")" +
					"AND (" +
					"     UPPER(o.inputText) like :searchText " +
					"  OR UPPER(o.replacementText) like :searchText" +
					")" +
					"ORDER BY o.inputText, o.replacementText ASC"),
	
	@NamedQuery(name=Autocompletion.GET_CONTEXTS,
			query = "SELECT DISTINCT o.context FROM Autocompletion o " +
					"WHERE o.context IS NOT NULL " +
					"ORDER BY o.context")
})
public class Autocompletion extends GECAMedEntityBean
{
	private static final long serialVersionUID = 1L;
	
	public static final String GET_ALL_COMPLETIONS 					= "getAllCompletions";
	public static final String GET_COMPLETIONS_BY_CONTEXT_AND_ID 	= "getCompletionsByContextAndID";
	public static final String GET_COMPLETIONS_BY_CONTEXT 			= "getCompletionsByContext";
	public static final String GET_SINGLE_COMPLETION 				= "getSingleCompletion";
	public static final String SEARCH_COMPLETIONS 					= "searchCompletions";
	public static final String GET_CONTEXTS 						= "getContexts";

	private String 	context;
	private String 	inputText;
	private String 	replacementText;
	private Integer userId;
	private Date 	created;
	private Date 	modified;
	
	
	
	public Autocompletion () {}
	
	public Autocompletion (String context, String inputText, String replacementText, Integer userId)
	{
		setContext(context);
		setInputText(inputText);
		setReplacementText(replacementText);
		setUserId(userId);
	}
	
	
	@Column(name="context")
	public String getContext ()
	{
		return context;
	}
	
	public void setContext (String context)
	{
		this.context = context;
	}

	@Column(name="short_cut")
	public String getInputText()
	{
		return inputText;
	}

	public void setInputText(String inputText)
	{
		if ("".equals(inputText))
			 this.inputText = null;
		else this.inputText = inputText;
	}

	@Column(name="replacement_text")
	public String getReplacementText()
	{
		return replacementText;
	}

	public void setReplacementText(String replacementText)
	{
		this.replacementText= replacementText;
	}

	@Column(name="user_id")
	public Integer getUserId()
	{
		return userId;
	}

	public void setUserId(Integer userId)
	{
		this.userId 		= userId;
	}

	@Column(name="created")
	public Date getCreated()
	{
		return created;
	}

	public void setCreated(Date created)
	{
		this.created 		= created;
	}

	@Column(name="modified")
	public Date getModified()
	{
		return modified;
	}

	public void setModified(Date modified)
	{
		this.modified 		= modified;
	}
	
	
	
	@Override
	public boolean equals(Object otherBean)
	{
		if (	   otherBean != null
				&& otherBean instanceof Autocompletion
				&& context != null
				&& replacementText != null)
		{
			Autocompletion acBean = (Autocompletion) otherBean;
			return 	   ((context == null && acBean.getContext() == null)
							|| (context != null && context.equals(acBean.getContext())))
					&& ((replacementText == null && acBean.getReplacementText() == null)
							|| (replacementText != null && replacementText.equals(acBean.getReplacementText())))
					&& ((inputText == null && acBean.getInputText() == null)
							|| (inputText != null && inputText.equals(acBean.getInputText())))
					&& ((userId == null && acBean.getUserId() == null)
							|| userId != null && userId.equals(acBean.getUserId()));
		}
		else
			return super.equals(otherBean);
	}
	
	
	@Transient
	public String getHashString()
	{
		return new StringBuilder()
						.append(context 		!= null ? context.hashCode() 		: "")
						.append('\n')
						.append(inputText 		!= null ? inputText.hashCode() 		: "")
						.append('\n')
						.append(replacementText != null ? replacementText.hashCode(): "")
						.append('\n')
						.append(userId 			!= null ? userId 					: "")
						.toString();
	}
}
