/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * Entity Bean that maps the <b>core.dr_title</b> table
 * which stores a list of all available titles
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.luc
 * 
 *  @Version
 * <br>$Log: DrTitle.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * 
 */
@javax.persistence.NamedQueries({
    @javax.persistence.NamedQuery(name="findAllDrTitle",
        query="SELECT OBJECT(o) FROM Title o"),
    @javax.persistence.NamedQuery(name="findAllDrTitleByValue",
        query="SELECT OBJECT(o) FROM Title o WHERE o.value = :value")
})

@Entity
@Table(name="dr_title", schema="core")
public class DrTitle extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;
	private String value;

	/**
	 * Get the value.
	 *
	 * @return The value.
	 */
	@javax.persistence.Column(name = "value")
	public java.lang.String getValue() {
		return value;
	}

	/**
	 * Set the value.
	 *
	 * @param value The value.
	 */
	public void setValue(String value) {
		this.value = value;
	}

	
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return this.getValue();
    }

	@Override
	public boolean equals(Object obj) {
		try {
			return this.getValue().equals(((DrTitle)obj).getValue());
		} catch (Exception e) {
			return false;
		}		
	}
    
}
