/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name = "external_password_store", schema = "core")

/**
 * Entity Bean that maps the <b>core.external_password_store</b> table
 * which stores all passwords for external uses like MedLogin.
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: ExternalPasswordStore.java,v $
 * <br>Revision 1.4  2013-12-27 18:09:25  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.3  2012-08-07 14:00:18  troth
 * <br>Add function to allow users to delete the login informations in the new table external password store.
 * <br>
 * <br>Revision 1.2  2012-08-06 14:04:04  troth
 * <br>Now the MedLogin service stores the tokens of the users in the new table external password store.
 * <br>
 * <br>Revision 1.1  2012-08-02 16:14:15  troth
 * <br>Add new table to database for external password store (for MedLogin and other Services).
 * <br>
 */
public class ExternalPasswordStore extends GECAMedEntityBean implements Serializable 
{
	private static final long serialVersionUID = 1L;
	
	private Integer userId;
	private Integer	physicianId;
	private String 	type;
	private String	key;
	private String	value;
	
	// -------------------------------------------------------
	// Getter and Setter Methods
	// -------------------------------------------------------
	/**
	 * Returns the user id of the password.
	 * @return the id of the user.
	 */
	@javax.persistence.Column (name ="user_id")
	public Integer getUserId() 
	{
		return this.userId;
	}
	
	/**
	 * Sets the user id of password to the specified value.
	 * @param userId specifies the id of the user for the password.
	 */
	public void setUserId(Integer userId) 
	{
		this.userId = userId;
	}
	
	/**
	 * Returns the physician id of the password.
	 * @return the id of the physician.
	 */
	@javax.persistence.Column (name ="physician_id")
	public Integer getPhysicianId() 
	{
		return this.physicianId;
	}
	
	/**
	 * Sets the physician id of password to the specified value.
	 * @param physicianId specifies the id of the physician for the password.
	 */
	public void setPhysicianId(Integer physicianId) 
	{
		this.physicianId = physicianId;
	}
	
	/**
	 * @return Returns the type of the password.
	 */
	@javax.persistence.Column (name ="type")

	public String getType() 
	{
		return this.type;
	}
	
	/**
	 * Sets the type of the password.
	 * @param type specifies the new of the password.
	 */
	public void setType(String type) 
	{
		this.type = type;
	}

	/** 
	 * @return Returns the key of a password.
	 */
	@javax.persistence.Column (name ="key")
	
	public String getKey() 
	{
		return this.key;
	}
	
	/**
	 * Sets the key of this password.
	 * @param Key specifies the new key of this password.
	 */
	public void setKey(String key) 
	{
		this.key = key;
	}

	/** 
	 * @return Returns the value which is the password.
	 */
	@javax.persistence.Column (name ="value")
	
	public String getValue() 
	{
		return this.value;
	}
	
	/**
	 * Sets the value which is the password.
	 * @param value specifies the new value.
	 */
	public void setValue(String value) 
	{
		this.value = value;
	}
}