/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.entity.beans;

import java.io.Serializable;
import java.util.Locale;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;


@javax.persistence.NamedQueries({
    @javax.persistence.NamedQuery(name="findAllGECAMedLocales",
        query="SELECT OBJECT(o) FROM GECAMedLocale o")
})

/**
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * Entity Bean that maps the <b>core.locale</b> table
 * which stores a list of all available system languages 
 * that are available for the users and translations etc
 * 
 */
@Entity
@Table(name="locale", schema="core")
public class GECAMedLocale extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	/**
	 * The english language pack 
	 */
	public static final String ENGLISH 	= "en";
	
	/**
	 * The german language pack
	 */
	public static final String GERMAN 	= "de";
	
	/**
	 * the french language pack
	 */
	public static final String FRENCH	= "fr";
	
	
	
	/** Regular field. */
	private String language;
	private String country;
	
	/**
	 * default contructor
	 */
	public GECAMedLocale() {}
	
	/**
	 * creates a GECAMedLocale from a provides java locale object
	 * @param l
	 */
	public GECAMedLocale(Locale l) {
		this.setCountry(l.getCountry());
		this.setLanguage(l.getLanguage());
	}
	
	
	/**
	 * Get the language part of the locale.
	 *
	 * @return The language.
	 */
	@javax.persistence.Column(name = "language")
	public java.lang.String getLanguage() {
		return language;
	}

	/**
	 * Set the language part of the locale..
	 *
	 * @param language
	 */
	public void setLanguage(String language) {
		this.language = language;
	}

	
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return this.getLanguage() + "_" + this.getCountry();
    }

	/**
	 * @return Returns the country part of the locale..
	 */
	@javax.persistence.Column(name = "country")
	public String getCountry() {
		return country;
	}

	/**
	 *  Sets the country part of the locale..
	 * @param country The country to set.
	 */
	public void setCountry(String country) {
		this.country = country;
	}
    
	/**
	 * returns the object as a java locale
	 * @return
	 */
	@Transient
	public Locale getLocale() {
		return new Locale(getLanguage(),getCountry());
	}
	
	/**
	 * sets a java locale to this object
	 * @param l
	 */
	@Transient
	public void setLocale(Locale l) {
		this.setCountry(l.getCountry());
		this.setLanguage(l.getLanguage());
	}

    
}
