/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.utils.AutoTranslatable;

/**
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * Entity Bean that maps the <b>core.gender</b> table
 * which stores a list of all available genders
 * 
 * 
 * 
 */


@javax.persistence.NamedQueries({

    @javax.persistence.NamedQuery(name="findAllGender",
        query="SELECT OBJECT(o) FROM Gender o"),
    @javax.persistence.NamedQuery(name="findAllGenderByValue",
        query="SELECT OBJECT(o) FROM Gender o WHERE o.value = :value")
})


@Entity
@Table(name="gender", schema="core")
public class Gender extends GECAMedEntityBean implements AutoTranslatable, Serializable {

	private static final long serialVersionUID = 1L;

	public static final String MALE 	= "male";
	public static final String FEMALE 	= "female";
	public static final String OTHER	= "other";
	public static final String UNKNOWN	= "unknown";
	
	
	/** Regular field. */
	private String value;

	/**
	 * Get the gender.
	 *
	 * @return The gender.
	 */
	@javax.persistence.Column(name = "value")
	public java.lang.String getValue() {
		return value;
	}

	/**
	 * Set the gender.
	 *
	 * @param value The gender.
	 */
	public void setValue(String gender) {
		this.value = gender;
	}

	
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return this.getValue();
    }

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		try {
			return this.getValue().equals(((Gender)obj).getValue());
		} catch (Exception e) {
			return false;
		}		
	}
	
	
	@Transient
	public String getTranslationKey ()
	{
		return getClass().getSimpleName() + "." + getValue();
	}
	
	
	@Transient
	public String getDefaultTranslation ()
	{
		return getValue();
	}
    
    
}
