/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author Johannes Hermen johannes.hermen(at)tudor.luc
 * 
 * Entity Bean that maps the <b>core.phone_type</b> table
 * which stores a list of all available phone types
 */

@javax.persistence.NamedQueries({

    @javax.persistence.NamedQuery(name="findAllPhoneType",
        query="SELECT OBJECT(o) FROM PhoneType o"),
    @javax.persistence.NamedQuery(name="findAllPhoneTypeByValue",
        query="SELECT OBJECT(o) FROM PhoneType o WHERE o.value = :value")
})

@Entity
@Table(name="phone_type", schema="core")
public class PhoneType extends GECAMedEntityBean implements Serializable {

	
	public static final String HOME = "private";
	public static final String MOBILE = "mobile";
	public static final String OFFICE = "office";
	public static final String FAX = "fax";
	
	
	
	private static final long serialVersionUID = 1L;
	/** Regular field. */
	private String value;

	/**
	 * Get the phone type.
	 *
	 * @return The phone type.
	 */
	@javax.persistence.Column(name = "value")
	public java.lang.String getValue() {
		return value;
	}

	/**
	 * Set the phone type.
	 *
	 * @param value The phone type.
	 */
	public void setValue(String phoneType) {
		this.value = phoneType;
	}

	
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return this.getValue();
    }

	@Override
	public boolean equals(Object obj) {
		try {
			return this.getValue().equals(((PhoneType)obj).getValue());
		} catch (Exception e) {
			return false;
		}		
	}
    
    
}
