///*******************************************************************************
// * This file is part of GECAMed.
// * 
// * GECAMed is free software: you can redistribute it and/or modify
// * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
// * the Free Software Foundation, either version 3 of the License, or
// * (at your option) any later version.
// * 
// * GECAMed is distributed in the hope that it will be useful,
// * but WITHOUT ANY WARRANTY; without even the implied warranty of
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// * GNU Lesser General Public License for more details.
// * 
// * You should have received a copy of the GNU Lesser General Public License (L-GPL)
// * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
// * 
// * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
// * (c) CRP Henri Tudor, Luxembourg, 2008
// *******************************************************************************/
//package lu.tudor.santec.gecamed.core.ejb.entity.beans;
//
//import java.io.Serializable;
//
//import javax.persistence.Entity;
//import javax.persistence.Table;
//
///**
// * @author Johannes Hermen johannes.hermen(at)tudor.luc
// * 
// * Entity Bean that maps the <b>core.template_type</b> table
// * which stores a list of all available printing template types
// */
//
//@javax.persistence.NamedQueries({
//
//    @javax.persistence.NamedQuery(name="findAllTemplateTypes",
//        query="SELECT OBJECT(o) FROM TemplateType o ORDER BY o.sequenceNumber ASC"),
//    @javax.persistence.NamedQuery(name="findTemplateTypesByName",
//                query="SELECT OBJECT(o) FROM TemplateType o WHERE o.value = :name")
//})
//
//@Entity
//@Table(name="template_type", schema="core")
//public class TemplateType extends GECAMedEntityBean implements Serializable {
//
//	
//	
//	private static final long serialVersionUID = 1L;
//
//	private String value;
//	private Integer sequenceNumber;
//	private String templateFilePath;
//	
//	/**
//	 * Get the type.
//	 *
//	 * @return The type.
//	 */
//	@javax.persistence.Column(name = "value")
//	public java.lang.String getValue() {
//		return value;
//	}
//
//	/**
//	 * Set the type.
//	 *
//	 * @param value The type.
//	 */
//	public void setValue(String type) {
//		this.value = type;
//	}
//
//	/**
//	 * Get the sequence or order number for this template type.
//	 *
//	 * @return The sequence or order number.
//	 */
//	@javax.persistence.Column(name = "sequence_number")
//	public java.lang.Integer getSequenceNumber() {
//		return this.sequenceNumber;
//	}
//
//	/**
//	 * Set the sequence or order number for this template type.
//	 *
//	 * @param sequenceNumber The new value of the sequence number.
//	 */
//	public void setSequenceNumber(Integer sequenceNumber) {
//		this.sequenceNumber = sequenceNumber;
//	}
//	
//    /* (non-Javadoc)
//     * @see java.lang.Object#toString()
//     */
//    public String toString() {
//        return this.getValue();
//    }
//
//	/* (non-Javadoc)
//	 * @see lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean#equals(java.lang.Object)
//	 */
//	@Override
//	public boolean equals(Object obj) {
//		try {
//			return this.getValue().equals(((TemplateType)obj).getValue());
//		} catch (Exception e) {
//			return false;
//		}		
//	}
//
//	/**
//	 * @return the templateFilePath
//	 */
//	@javax.persistence.Column(name = "template_file_path")
//	public String getTemplateFilePath() {
//	    return templateFilePath;
//	}
//
//	/**
//	 * @param templateFilePath the templateFilePath to set
//	 */
//	public void setTemplateFilePath(String templateFilePath) {
//	    this.templateFilePath = templateFilePath;
//	}
//    
//    
//}
