/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.utils.AutoTranslatable;
import lu.tudor.santec.i18n.Translatrix;

/**
 * @author Johannes Hermen johannes.hermen(at)tudor.luc
 * 
 * Entity Bean that maps the <b>core.title</b> table
 * which stores a list of all available titles
 */

@javax.persistence.NamedQueries({

    @javax.persistence.NamedQuery(name="findAllTitle",query="SELECT OBJECT(o) FROM Title o"),
    @javax.persistence.NamedQuery(name="findAllTitleByValue",query="SELECT OBJECT(o) FROM Title o WHERE o.value = :value")
})

@Entity
@Table(name="title", schema="core")
public class Title extends GECAMedEntityBean implements AutoTranslatable, Serializable {

	private static final long serialVersionUID = 1L;
	/** Regular field. */
	private String value;
	
	
	public static final String MISTER = "mister";
	public static final String MADAM = "madam";
	public static final String MISS = "miss";
	public static final String EMPTY = "";

	/**
	 * Get the title.
	 *
	 * @return The title.
	 */
	@javax.persistence.Column(name = "value")
	public java.lang.String getValue() {
		return value;
	}

	/**
	 * Set the title.
	 *
	 * @param value The title.
	 */
	public void setValue(String title) {
		this.value = title;
	}

	
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return this.getValue();
    }

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		try {
			return this.getValue().equals(((Title)obj).getValue());
		} catch (Exception e) {
			return false;
		}		
	}
	
	
	/**
	 * @return the translated title
	 */
	@Transient
	public static String translate(String title)
			{
				if (title!= null)
					{
						String newKey = "Title." + title;
						String getKey = Translatrix.getTranslationString(newKey);
						if (newKey.equals(getKey))
							{
								return title;
							} else
							{
								return getKey;								
							}
					}
				return "";
			}
	
	
	@Transient
	public String getTranslationKey ()
	{
		return getClass().getSimpleName() + "." + getValue();
	}
	
	
	@Transient
	public String getDefaultTranslation ()
	{
		return getValue();
	}
    
    
}
