/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * 
 */
package lu.tudor.santec.gecamed.core.ejb.entity.beans.log;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;


/**
 * The entity for the log types
 * 
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: LogType.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2006/11/22 13:00:08  heinemann
 * <br>fixed package name
 * <br>
 * <br>Revision 1.2  2006/11/07 08:11:32  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2006/10/24 09:18:22  heinemann
 * <br>New Beans for the logging
 * <br>
 */

@Entity
@Table(name="log_types", schema="core")
public class LogType extends GECAMedEntityBean {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public static final int SYSTEM 		= 1;
	public static final int ERROR 		= 2;
	public static final int ADMIN 		= 3;
	public static final int USER 		= 4;
	
	

	/* ********************************************************************** */
	/*                  Class Members										  */
	/* ---------------------------------------------------------------------- */
	
	
	/**
	 * The name of the log type 
	 */
	private String name;
	
	/* --------------------------------------------------------------------------- */
	/*                          End of Class Members                               */
	/* *************************************************************************** */
	
	
	/**
	 * 
	 */
	public LogType() {
		/* ====================================================== */
		super();
		/* ====================================================== */
	}
	
	public LogType(String name) {
		super();
		this.name = name;
	}
	
	
	public String toString() {
		/* ====================================================== */
		return this.name;
		/* ====================================================== */
	}
	
	/* ****************************************************************************** */
	/*                               Getter and Setter                                */
	/* ------------------------------------------------------------------------------ */

	/**
	 * @return the name
	 */
	@Column(name="name")
	public String getName() {
		return name;
	}
	
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/* ------------------------------------------------------------------------------- */
	/*                      End of Getter and Setter                                   */
	/* ******************************************************************************* */
	
	
}
