/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.session.beans;

import java.util.List;

import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.NoResultException;
import javax.persistence.Query;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.core.ejb.session.interfaces.EntityMapperInterface;
import lu.tudor.santec.gecamed.core.utils.querybuilder.HibernateQueryFactory;
import lu.tudor.santec.gecamed.core.utils.querybuilder.WhereClause;

@Stateless
@Remote (EntityMapperInterface.class)
public class EntityMapperBean extends GECAMedSessionBean implements EntityMapperInterface
	{

//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
	static 
	{
		// set the logging level for Apache FOP to ERROR
		org.apache.log4j.Logger.getLogger("org.apache.fop").setLevel(org.apache.log4j.Level.ERROR);
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
@RolesAllowed("gecam")
public GECAMedEntityBean getReference (String p_ClassName, WhereClause p_Clause) throws Exception
	{
	Query				l_Query;
	String				l_QueryString;
	GECAMedEntityBean	l_Reference = null;
	
	if ((p_ClassName == null) || (p_Clause == null)) return null;

	l_QueryString = "SELECT OBJECT(o) FROM " + p_ClassName + " o ";

	try	{
		l_Query = HibernateQueryFactory.buildQueryFromWhereClause (m_EntityManager,l_QueryString, p_Clause);
		List<?> l = l_Query.getResultList();
		if (l != null && l.size() > 0)
		    l_Reference = (GECAMedEntityBean) l.get(0);
		}
	catch (NoResultException p_Exception)
		{
		// Simply Return null
		}
	
	return l_Reference;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
