/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.session.beans;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.ExternalPasswordStore;
import lu.tudor.santec.gecamed.core.ejb.session.interfaces.ExternalPasswordStoreInterface;


/**
 * This SessionBean class manages the getter access to the password store.
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: ExternalPasswordStoreBean.java,v $
 * <br>Revision 1.4  2012-08-07 14:00:18  troth
 * <br>Add function to allow users to delete the login informations in the new table external password store.
 * <br>
 * <br>Revision 1.3  2012-08-06 15:56:56  troth
 * <br>remove syso.
 * <br>
 * <br>Revision 1.2  2012-08-06 14:04:04  troth
 * <br>Now the MedLogin service stores the tokens of the users in the new table external password store.
 * <br>
 * <br>Revision 1.1  2012-08-02 16:14:15  troth
 * <br>Add new table to database for external password store (for MedLogin and other Services).
 * <br>
 */
@Stateless
@Remote (ExternalPasswordStoreInterface.class)

public class ExternalPasswordStoreBean implements ExternalPasswordStoreInterface
{
	private static final long serialVersionUID = 1L;
	
	@PersistenceContext (unitName="gecam")
	EntityManager entityManager;

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.ejb.session.interfaces.ExternalPasswordStoreInterface#getPassword(java.lang.Integer, java.lang.String, java.lang.String)
	 */
	public ExternalPasswordStore getPassword(Integer physicianId, String type, String key) throws Exception
	{
		if(physicianId == null)
			return null;
		
		Query result = entityManager.createQuery("SELECT OBJECT(o) FROM ExternalPasswordStore o "
				+ "WHERE o.physicianId = " + physicianId
				+ "AND o.type = '" + type + "' "
				+ "AND o.key = '" + key + "'");
		try {
			/* ------------------------------------------------------- */
			ExternalPasswordStore password = (ExternalPasswordStore) result.getSingleResult();
			return password;
			/* ------------------------------------------------------- */
		} catch (Exception e) {
			return null;
		}
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.ejb.session.interfaces.ExternalPasswordStoreInterface#savePassword(lu.tudor.santec.gecamed.core.ejb.entity.beans.ExternalPasswordStore)
	 */
	public ExternalPasswordStore savePassword(ExternalPasswordStore password) throws Exception
	{
		if(password == null)
			return null;
		    	
		return entityManager.merge(password);
	}
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.ejb.session.interfaces.ExternalPasswordStoreInterface#deletePassword(lu.tudor.santec.gecamed.core.ejb.entity.beans.ExternalPasswordStore)
	 */
	public void deletePassword(ExternalPasswordStore password) throws Exception
	{
		if(password != null)
		{
			password = entityManager.find(ExternalPasswordStore.class, password.getId());
			if(password != null)
			{
				entityManager.remove(password);
			}
		}
	}

}
