/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.session.interfaces;

import java.io.IOException;

import javax.ejb.Remote;

/**
 * @author martin.heinemann@tudor.lu
 * 24.07.2008
 * 11:56:16
 *
 *
 * @version
 * <br>$Log: ChunkedFileManager.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-07-25 14:42:42  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
@Remote
public interface ChunkedFileManager {

	/**
	 * @param patientId
	 * @param name
	 * @throws Exception 
	 */
	public void createFile(Integer patientId, String name) throws Exception;
	
	/**
	 * Create a file in the tmp folder
	 * 
	 * @param name
	 * @throws Exception
	 */
	public void createFile(String name) throws Exception;

	/**
	 * recieves data and appends it to the file
	 * 
	 * @param b
	 * @throws IOException 
	 */
	public void recieve(byte[] b) throws IOException;

	/**
	 * Closes the files
	 * @return the filename of the stored file
	 */
	public String closeFile();

	
	
	
}
