/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.session.interfaces;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.ExternalPasswordStore;

/**
 * The external password store interface.
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: ExternalPasswordStoreInterface.java,v $
 * <br>Revision 1.3  2012-08-07 14:00:18  troth
 * <br>Add function to allow users to delete the login informations in the new table external password store.
 * <br>
 * <br>Revision 1.2  2012-08-06 14:04:04  troth
 * <br>Now the MedLogin service stores the tokens of the users in the new table external password store.
 * <br>
 * <br>Revision 1.1  2012-08-02 16:14:15  troth
 * <br>Add new table to database for external password store (for MedLogin and other Services).
 * <br>
 */
@Remote
public interface ExternalPasswordStoreInterface 
{

	/**
	 * Get password specified by the physician id, the password type and the key  
	 * @param physician_id
	 * @param type
	 * @param key
	 * @return the password (the value of the password store)
	 * @throws Exception
	 */
	public ExternalPasswordStore getPassword(Integer physician_id, String type, String key) throws Exception;

	/**
	 * Save the password in the database password store.
	 * @param password
	 * @return the saved password
	 * @throws Exception
	 */
	public ExternalPasswordStore savePassword(ExternalPasswordStore password) throws Exception;
	
	/**
	 * Delete the password in the database password store.
	 * @param password
	 * @throws Exception
	 */
	public void deletePassword(ExternalPasswordStore password) throws Exception;

}
