/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.session.interfaces;

import java.util.List;
import java.util.Properties;

import javax.annotation.security.RolesAllowed;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedLocale;
import lu.tudor.santec.gecamed.core.ejb.entity.beans.NationalHoliday;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedInfo;

/**
 *
 *	This SessionBean interface manages the getter access to the static lists like
 *	Languages, Titles, Genders etc...
 * It allthough provides a method to retrieve some server-infos like server-build date etc..
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * @Version
 * <br>$Log: ListManagerInterface.java,v $
 * <br>Revision 1.16  2013-11-05 14:50:09  ferring
 * <br>method added to save / merge a bean
 * <br>
 * <br>Revision 1.15  2013-10-31 14:05:41  ferring
 * <br>methods added to get any bean by class and ID
 * <br>
 * <br>Revision 1.14  2013-02-19 12:07:34  ferring
 * <br>GECAMedLists changed. Will now automatically load list of all beans
 * <br>
 * <br>Revision 1.13  2009-06-03 09:22:53  hermen
 * <br>show core.info table in about dialog
 * <br>
 * <br>Revision 1.12  2009-05-15 07:34:04  hermen
 * <br>show core.info in about dialog
 * <br>
 * <br>Revision 1.11  2009-05-08 07:59:27  hermen
 * <br>open help website on firstrun
 * <br>
 * <br>Revision 1.10  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.9  2008-01-15 10:44:12  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.8  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.7  2007-12-03 09:06:57  hermen
 * <br>updated Javadoc
 * <br>
 *
 */
public interface ListManagerInterface {


    public static final String JBOSS_DIR = "JBOSS_DIR";

    public static final String GECAMED_DIR = "GECAMED_DIR";
    
	/**
	 * retrieves all Gender Beans
	 * @return all Gender Beans
	 * @throws Exception
	 */
	@RolesAllowed("gecam")
	public abstract String[] getGenders() throws Exception;

	/**
	 * retrieves all Language Beans
	 * @return all Language Beans
	 * @throws Exception
	 */
	@RolesAllowed("gecam")
	public abstract String[] getLanguages() throws Exception;

	/**
	 * retrieves all MaritalStatus Beans
	 * @return all MaritalStatus Beans
	 * @throws Exception
	 */
	@RolesAllowed("gecam")
	public abstract String[] getMaritalStates() throws Exception;

	/**
	 * retrieves all Nationality Beans
	 * @return all Nationality Beans
	 * @throws Exception
	 */
	@RolesAllowed("gecam")
	public abstract String[] getNationalities() throws Exception;

	/**
	 * retrieves all PhoneType Beans
	 * @return all PhoneType Beans
	 * @throws Exception
	 */
	@RolesAllowed("gecam")
	public abstract String[] getPhoneTypes() throws Exception;

	/**
	 * retrieves all Title Beans
	 * @return all Title Beans
	 * @throws Exception
	 */
	@RolesAllowed("gecam")
	public abstract String[] getTitles() throws Exception;
	
	/**
	 * retrieves all DrTitle Beans
	 * @return all DrTitle Beans
	 * @throws Exception
	 */
	@RolesAllowed("gecam")
	public abstract String[] getDrTitles() throws Exception;

    /**
     * retrieves all GecamedLocale Beans
     * @return all GecamedLocale Beans
     * @throws Exception
     */
	@RolesAllowed("gecam")
    public GECAMedLocale[] getGECAMedLocales() throws Exception;
    
    /**
     * retrieves all NationalHoliday Beans
     * @return all NationalHoliday Beans
     * @throws Exception
     */
	@RolesAllowed("gecam")
    public NationalHoliday[] getNationalHolidays() throws Exception;

    /**
     * retrieves some Server Infos such as the build date of the GECAMed server
     * @return Server Properties
     * @throws Exception
     */
	@RolesAllowed("gecam")
	public Properties getServerInfos() throws Exception;
    
	/**
	 * retrieves some Server Infos from the core.info table;
	 * @return Server Properties
	 * @throws Exception
	*/
	@RolesAllowed("gecam")
	public List<GecamedInfo> getCoreInfos() throws Exception;
	
	@RolesAllowed("gecam")
	public <T> List<T> getAllBeans (Class<T> clazz);
	
	@RolesAllowed("gecamed")
	public <T> T getBean (Class<T> clazz, Integer id);
	
	@RolesAllowed("gecamed")
	public <T extends GECAMedEntityBean> T saveBean (T bean);
	
	public <T extends GECAMedEntityBean> void removeBean (T bean);
	
	public <T extends GECAMedEntityBean> List<T> getListReference (Class<T> clazz);
	
	public void resetList (Class<?> clazz);
}
