/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.session.interfaces;

import java.util.Date;
import java.util.List;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.log.Log;
import lu.tudor.santec.gecamed.core.ejb.entity.beans.log.LogType;

/**
 * The LogManager stores and readfs all log messages
 * 
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: LogManager.java,v $
 * <br>Revision 1.5  2013-01-09 08:29:18  ferring
 * <br>Errors in auto backup caught
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2006/11/22 13:00:31  heinemann
 * <br>you shouldn't do that, stefan ;-)
 * <br>
 * <br>Revision 1.2  2006/11/07 08:11:31  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2006/10/24 09:18:39  heinemann
 * <br>New Beans for the logging
 * <br>
 */
@Remote
public interface LogManager {
	
	
	public static final String UPDATE_MESSAGE = "UPDATE";
	
	/**
	 * Persists a log message
	 * The date of the log will be overwritten by the SessionBean due to 
	 * gain consistently dates.<br><br>
	 * It is not allowed to overwrite a log message.
	 * Once it is saved, it can not be modified anymore.<br>
	 * If this method recieves a persistant entity, it will create a new one and save it.
	 * 
	 * 
	 * @param log
	 */
//	@RolesAllowed("gecam")
	public void saveLog(Log log);

	
	/**
	 * Returns a list of all log messages, sorted by the date.
	 * 
	 * @param start the start position of the log messages
	 * @param pagesize the pagesize of the messages
	 * @param fromDate
	 * @param toDate
	 * @param filter
	 * @return
	 */
	public List<Log> getLogs(Integer start, Integer pagesize, Date fromDate, Date toDate, String filter);
	
	
	/**
	 * Returns all log types
	 * 
	 * @return
	 */
	public List<LogType> getLogTypes();
	
	public void createLogMessage(Integer logType, String module, String operation, String message, Long duration);
	
	
}
