/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.session.interfaces;

import java.io.Serializable;
import java.util.List;

import javax.ejb.Remote;
import javax.jms.JMSException;
import javax.naming.NamingException;

import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.UserMessage;

/**
 * 
 *	This SessionBean interface manages provides methods to send JMS-Messages 
 * to the GECAMed JMS Channels, on which all GECAMed-Clients are listening.
 * There channels are used to upate the client if the used data changes
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * @Version
 * <br>$Log: MessageSenderInterface.java,v $
 * <br>Revision 1.7  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.6  2008-01-15 10:44:12  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.5  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.4  2007-12-03 09:06:57  hermen
 * <br>updated Javadoc
 * <br>
 *
 */
@Remote
public interface MessageSenderInterface {

	public static final String ALL_USERS = "ALL";
	public static final String RECEIVER = "RECEIVER";
	public static final String SENDER = "SENDER";
	public static final String IMPORTANT = "IMPORTANT";

    /**
     * sends a ObjectMessage to the JMS-Channel the clients are listening on.
     *
     * @param object the Serializable Object to send
     * @throws JMSException
     * @throws NamingException
     * @ejb.interface-method view-type = "both"
     */
    public void sendObjectMessage(Serializable object) throws JMSException;

    /**
     * sends a textMessage to the JMS-Channel the clients are listening on.
     *
     * @param text the Messagetext to send
     * @throws JMSException
     * @throws NamingException
     * @ejb.interface-method view-type = "both"
     */
    public void sendTextMessage(String text, String receiver, boolean important) throws JMSException;
            
    public void notify(UserMessage message) throws Exception;
    
    /**
     * Triggers the log module to get a new list of the logs
     * 
     * @throws JMSException
     */
    public void sendLogUpdateMessage() throws JMSException;

}
