/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui;

/**
 * A Message Object to send Global events from one Module to another.
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: GECAMedMessage.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.2  2007-12-03 10:59:02  hermen
 * <br>updated Javadoc
 * <br>
 *
 */
public class GECAMedMessage {

	private GECAMedModule modul;
	private String message;
	private Object oldValue;
	private Object newValue;

	/**
	 * creates a new GECAMedMessage
	 * @param modul the sending Module
	 * @param message the type of Message (should be defined in the sending Class/Module)
	 * @param oldValue the old Value
	 * @param newValue the new Value
	 */
	public GECAMedMessage(GECAMedModule modul, String message, Object oldValue, Object newValue) {
		this.modul = modul;
		this.message = message;
		this.oldValue = oldValue;
		this.newValue = newValue;
	}

	/**
	 * @return the the type of Message (should be defined in the sending Class/Module)
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * @param message the type of Message (should be defined in the sending Class/Module)
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * @return  the sending GECAMedModule
	 */
	public GECAMedModule getModul() {
		return modul;
	}

	/**
	 * @param modul  the sending GECAMedModule
	 */
	public void setModul(GECAMedModule modul) {
		this.modul = modul;
	}

	/**
	 * @return the new Value
	 */
	public Object getNewValue() {
		return newValue;
	}

	/**
	 * @param newValue the new Value
	 */
	public void setNewValue(Object newValue) {
		this.newValue = newValue;
	}

	/**
	 * @return the old Value
	 */
	public Object getOldValue() {
		return oldValue;
	}

	/**
	 * @param oldValue the old Value
	 */
	public void setOldValue(Object oldValue) {
		this.oldValue = oldValue;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return getModul().getName() + ": " + getMessage() + " oldVal: " + getOldValue() + " newVal: " + getNewValue();
	}
	
}
