/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.core.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;

import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.builder.ButtonBarBuilder;


/**
 * @author martin.heinemann@tudor.lu
 * 24.04.2007
 * 09:22:44
 *
 *
 * @version
 * <br>$Log: GECAMedOptionPane.java,v $
 * <br>Revision 1.10  2010-12-03 10:18:08  troth
 * <br>Complete - # 649: Wartesaal nur fr einen Arzt anzeigen
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/649
 * <br>
 * <br>Revision 1.9  2010-09-07 16:22:16  troth
 * <br>Workaround for Ticket # 630: Abbruch reagiert falsch im Accident Modifizier-Dialog
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/630
 * <br>
 * <br>Revision 1.8  2010-04-27 14:36:37  troth
 * <br>GECAMedOptionPane create now only a simple JOptionPane. May be later we build our own optionpane.
 * <br>
 * <br>Revision 1.7  2009-02-09 15:07:24  heinemann
 * <br>addedd jdialog constructor.
 * <br>but seems to be broken, no buttons?!
 * <br>
 * <br>Revision 1.6  2009-01-22 07:35:51  hermen
 * <br>improved startup logging and progress dialog
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-03-11 17:17:11  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-02-27 14:23:36  heinemann
 * <br>an littlebit nicer
 * <br>
 * <br>Revision 1.2  2007/04/25 06:05:47  heinemann
 * <br>added default option "OK"
 * <br>
 * <br>Revision 1.1  2007/04/24 13:46:44  heinemann
 * <br>initial checkin
 * <br>
 *
 */

// TODO
// Create a simple JOptionPane. May be later we build our own.

//public class GECAMedOptionPane {
public class GECAMedOptionPane extends JOptionPane {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;


	public static final int ICON_QUESTION = 0;
	public static final int ICON_WARNING  = 1;


	private static final Icon[] ICONS = {
									GECAMedModule.getScaledIcon(GECAMedIconNames.HELP, 32),
									GECAMedModule.getScaledIcon(GECAMedIconNames.WARNING, 32)
									};

	private static JDialog dialog;

	/**
	 * The return value
	 */
	private static int value;

	/**
	 * @param parent
	 * @param title translatrix string for the title
	 * @param message translatrix string for the message
	 * @param optionStyle use options from JOptionPane
	 * @param icon use GECAMedOptionPane.ICON_ constants
	 * @return an int indicating the option selected by the user
	 */
//	public static int showOptionDialog(Component parentComponent, String title,
//			String message, int optionStyle,
//			int icon) {
	public static int showOptionDialog(Component parentComponent, String title,
								String message, int optionStyle) {
		
		value = JOptionPane.showConfirmDialog(
				parentComponent,
				message,
				title,
				optionStyle);
		return value;
		
		/* ================================================== */
//		value = JOptionPane.CANCEL_OPTION;
//
//		createDialog(parent, title, message, optionStyle, icon);
//		MainFrame.showDialogCentered(dialog);
//
//		return value;
		/* ================================================== */

	}
	public static int showOptionDialogWithoutClose(Component parentComponent, String title,
			String message, int optionStyle) {

		final JOptionPane optionPane = new JOptionPane(
				message,
				JOptionPane.QUESTION_MESSAGE,
				optionStyle);
		
	final JDialog dialog = new JDialog((Frame) parentComponent,title,true);

	dialog.setContentPane(optionPane);
	dialog.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
	optionPane.addPropertyChangeListener(
		    new PropertyChangeListener() {
		        public void propertyChange(PropertyChangeEvent e) {
		            String prop = e.getPropertyName();

		            if (dialog.isVisible() 
		             && (e.getSource() == optionPane)
		             && (prop.equals(JOptionPane.VALUE_PROPERTY))) {
		                dialog.setVisible(false);
		                
		            }
		        }
		    });
	dialog.pack();
	dialog.setLocationRelativeTo(parentComponent);
	dialog.setVisible(true);

	int value = ((Integer)optionPane.getValue()).intValue();
	return value;
	
	}

	
	/**
	 * @param parent
	 * @param title translatrix string for the title
	 * @param message translatrix string for the message
	 * @param optionStyle use options from JOptionPane
	 * @param icon use GECAMedOptionPane.ICON_ constants
	 * @return
	 */
//	public static int showOptionDialog(JDialog parent, String title,
//								String message, int optionStyle,
//								int icon) {
//		/* ================================================== */
//		value = JOptionPane.CANCEL_OPTION;
//
//		createDialog(parent, title, message, optionStyle, icon);
//		MainFrame.showDialogCentered(dialog);
//
//		return value;
//		/* ================================================== */
//
//	}
	
	
	/**
	 * @param parent
	 * @param title
	 * @param message
	 * @param optionStyle
	 * @param icon
	 */
	private static void createDialog(JDialog parent, String title,
			String message, int optionStyle,
			int icon) {
		/* ================================================== */
		dialog = new JDialog(parent, true);
		initDialog(title, message, optionStyle, icon);
		/* ================================================== */
	}
	
	
	/**
	 * @param parent
	 * @param title
	 * @param message
	 * @param optionStyle
	 * @param icon
	 * @return
	 */
	private static void createDialog(Frame parent, String title,
			String message, int optionStyle,
			int icon) {
		/* ================================================== */
		dialog = new JDialog(parent, true);
		initDialog(title, message, optionStyle, icon);
		/* ================================================== */
	}
	
	
	private static void initDialog(String title, String message, int optionStyle, int icon) {
		/* ================================================== */
		dialog.setTitle(Translatrix.getTranslationString(title));

		dialog.setLayout(new BorderLayout(5, 5));
		/* ------------------------------------------------------- */
		// a label in the north containg the icon and the message
		JLabel msgLabel = new JLabel("<html><span align=\"center\">"+Translatrix.getTranslationString(message));
		msgLabel.setIcon(ICONS[icon]);
		msgLabel.setHorizontalTextPosition(SwingConstants.RIGHT);
		msgLabel.setFont(new Font(msgLabel.getFont().getName(), msgLabel.getFont().getStyle(), 15));
		/* ------------------------------------------------------- */
		dialog.add(msgLabel, BorderLayout.CENTER);
		
		dialog.getContentPane().setBackground(GECAMedColors.c_GECAMedBackground);
		/* ------------------------------------------------------- */
		// guifications
		msgLabel.setBorder(BorderFactory.createTitledBorder(""));
		dialog.add(new JLabel(" "), BorderLayout.WEST);
		dialog.add(new JLabel(" "), BorderLayout.EAST);
		dialog.add(new JLabel(""), BorderLayout.NORTH);
		/* ------------------------------------------------------- */
		// the buttons
		dialog.add(createButtonPanel(optionStyle), BorderLayout.SOUTH);

		dialog.setMinimumSize(new Dimension(350, 250));
		dialog.pack();
		/* ================================================== */
	}
	

	/**
	 * @param optionStyle
	 * @return
	 */
	private static JPanel createButtonPanel(int optionStyle) {
		/* ================================================== */
//		JButton ok = new JButton(Translatrix.getTranslationString("core.yes"));
//		JButton no = new JButton(Translatrix.getTranslationString("core.no"));

		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addGlue();

		if (JOptionPane.DEFAULT_OPTION == optionStyle) {
			/* ------------------------------------------------------- */
			JButton ok = new JButton();
			/* ------------------------------------------------------- */
			ok.setAction(createAction("core.ok", GECAMedIconNames.OK,     JOptionPane.OK_OPTION));
			/* ------------------------------------------------------- */
			bb.addGridded(ok);
			bb.addGlue();
			/* ------------------------------------------------------- */
			KeyStroke strokeEnter = KeyStroke.getKeyStroke("ENTER");
			((JPanel) dialog.getContentPane()).getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
						.put(strokeEnter, "ok");
			((JPanel) dialog.getContentPane()).getActionMap().put("ok", ok.getAction());
			/* ------------------------------------------------------- */
		}

		if (JOptionPane.YES_NO_OPTION == optionStyle) {
			/* ------------------------------------------------------- */
			JButton yes = new JButton();
			JButton no = new JButton();
			/* ------------------------------------------------------- */
			yes.setAction(createAction("core.yes", GECAMedIconNames.OK,     JOptionPane.YES_OPTION));
			no.setAction(createAction( "core.no",  GECAMedIconNames.NO, JOptionPane.NO_OPTION));

			bb.addGridded(yes);
			bb.addRelatedGap();
			bb.addGridded(no);
			bb.addGlue();
			// define dialog wide key mappings
			KeyStroke strokeEsc = KeyStroke.getKeyStroke("ESCAPE");
			((JPanel) dialog.getContentPane()).getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
						.put(strokeEsc, "cancel");
			((JPanel) dialog.getContentPane()).getActionMap().put("cancel", no.getAction());


			KeyStroke strokeEnter = KeyStroke.getKeyStroke("ENTER");
			((JPanel) dialog.getContentPane()).getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
						.put(strokeEnter, "yes");
			((JPanel) dialog.getContentPane()).getActionMap().put("yes", yes.getAction());
			/* ------------------------------------------------------- */
		}
		if (JOptionPane.YES_NO_CANCEL_OPTION == optionStyle) {
			/* ------------------------------------------------------- */
			JButton yes = new JButton();
			JButton no = new JButton();
			JButton cancel = new JButton();
			/* ------------------------------------------------------- */
			yes.setAction(createAction("core.yes", GECAMedIconNames.OK,     JOptionPane.YES_OPTION));
			no.setAction(createAction( "core.no",  GECAMedIconNames.NO, JOptionPane.NO_OPTION));
			cancel.setAction(createAction( "core.cancel",  GECAMedIconNames.CANCEL, JOptionPane.CANCEL_OPTION));
			bb.addGridded(yes);
			bb.addRelatedGap();
			bb.addGridded(no);
			bb.addRelatedGap();
			bb.addGridded(cancel);
			bb.addGlue();


			// define dialog wide key mappings
			KeyStroke strokeEsc = KeyStroke.getKeyStroke("ESCAPE");
			((JPanel) dialog.getContentPane()).getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
						.put(strokeEsc, "cancel");
			((JPanel) dialog.getContentPane()).getActionMap().put("cancel", cancel.getAction());


			KeyStroke strokeEnter = KeyStroke.getKeyStroke("ENTER");
			((JPanel) dialog.getContentPane()).getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
						.put(strokeEnter, "yes");
			((JPanel) dialog.getContentPane()).getActionMap().put("yes", yes.getAction());


			/* ------------------------------------------------------- */
		}
		
		bb.getPanel().setBackground(Color.WHITE);
		
		return bb.getPanel();
		/* ================================================== */
	}



	private static Action createAction(String title, String icon, final int option) {
		/* ================================================== */
		Action action = new AbstractAction(Translatrix.getTranslationString(title),
				GECAMedModule.getMediumIcon(icon)) {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e) {
				/* ====================================================== */
				value = option;
				dialog.setVisible(false);
				/* ====================================================== */
			}
		};

		return action;
		/* ================================================== */
	}
}
