/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui;

import java.util.HashMap;

import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.AppConfigurationEntry.LoginModuleControlFlag;
import javax.security.auth.login.Configuration;

/**
 * Helper class for the JAAS Login Module in the GECAMed client
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * @Version
 * <br>$Log: JaasJbossConfiguration.java,v $
 * <br>Revision 1.5  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.2  2007-12-03 10:59:02  hermen
 * <br>updated Javadoc
 * <br>
 *
 */
public class JaasJbossConfiguration extends Configuration {

       @SuppressWarnings("unchecked")
	private static AppConfigurationEntry jbossEntry = new AppConfigurationEntry(
                       "org.jboss.security.ClientLoginModule",
                       LoginModuleControlFlag.REQUIRED,
                       new HashMap());

     /**
     * sets the configuration
     */
    public static void activateConfiguration() {
               Configuration.setConfiguration( new JaasJbossConfiguration() );
       }

       /* (non-Javadoc)
     * @see javax.security.auth.login.Configuration#getAppConfigurationEntry(java.lang.String)
     */
    @Override
       public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
               return new AppConfigurationEntry[] { jbossEntry };
       }

       /* (non-Javadoc)
     * @see javax.security.auth.login.Configuration#refresh()
     */
    @Override
       public void refresh() {
       }
}
