/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * Author: Johannes Hermen Tudor/Santec
 * Mail: johannes.hermen@tudor.lu
 * Created: Mar 2, 2005
 *
 */
package lu.tudor.santec.gecamed.core.gui;

import java.io.IOException;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

/**
 *  a simple Callbackhandler to authenticate to JBoss over JAAS
 *  
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: LoginCallbackHandler.java,v $
 * <br>Revision 1.5  2009-05-07 08:26:45  hermen
 * <br>handle password changing without restarting
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.2  2007-12-03 10:59:02  hermen
 * <br>updated Javadoc
 * <br>
 *
 */
public class LoginCallbackHandler implements CallbackHandler
{
    //~ Instance fields ========================================================

    private String pass;
    private String user;

    //~ Constructors ===========================================================
    /**
     * creates a new CallbackHandler with the given username and password
     *
     * @param user the Username to login
     * @param pass the Password to login
     */
    public LoginCallbackHandler(String user, String pass)
    {
        this.user = user;
        this.pass = pass;
    }
    
    public void renewPassword(String pass) {
	this.pass = pass;
    }
    
    //~ Methods ================================================================

    /* (non-Javadoc)
     * @see javax.security.auth.callback.CallbackHandler#handle(javax.security.auth.callback.Callback[])
     */
    public void handle(Callback[] callbacks)
        throws IOException, UnsupportedCallbackException
    {
        for (int i = 0; i < callbacks.length; i++) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback) callbacks[i];
                nameCallback.setName(user);
            } else if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pwCallback = (PasswordCallback) callbacks[i];
                pwCallback.setPassword(pass.toCharArray());
            } else {
                throw new UnsupportedCallbackException(callbacks[i]);
            }
        }
    }
}
