package lu.tudor.santec.gecamed.core.gui.controller.data;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;


public class HtmlTransferable implements Transferable
{
	/* ======================================== */
	// 		FINAL MEMBERS
	/* ======================================== */
	
	private static final ArrayList<DataFlavor> htmlFlavors = new ArrayList<DataFlavor>();
	
	static
	{
		try {
			htmlFlavors.add(new DataFlavor("text/html; class=java.lang.String"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.lang.String; charset=UTF-8"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.lang.String; charset=UTF-16"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.lang.String; charset=Unicode"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.io.Reader; charset=Unicode"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.nio.CharBuffer; charset=Unicode"));
			htmlFlavors.add(new DataFlavor("text/html; class=\"[C\"; charset=Unicode"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.io.InputStream; charset=UTF-16"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.nio.ByteBuffer; charset=UTF-16"));
			htmlFlavors.add(new DataFlavor("text/html; class=\"[B\"; charset=UTF-16"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.io.InputStream; charset=UTF-8"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.nio.ByteBuffer; charset=UTF-8"));
			htmlFlavors.add(new DataFlavor("text/html; class=\"[B\"; charset=UTF-8"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.io.InputStream; charset=UTF-16BE"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.nio.ByteBuffer; charset=UTF-16BE"));
			htmlFlavors.add(new DataFlavor("text/html; class=\"[B\"; charset=UTF-16BE"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.io.InputStream; charset=UTF-16LE"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.nio.ByteBuffer; charset=UTF-16LE"));
			htmlFlavors.add(new DataFlavor("text/html; class=\"[B\"; charset=UTF-16LE"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.io.InputStream; charset=ISO-8859-1"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.nio.ByteBuffer; charset=ISO-8859-1"));
			htmlFlavors.add(new DataFlavor("text/html; class=\"[B\"; charset=ISO-8859-1"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.io.InputStream; charset=US-ASCII"));
			htmlFlavors.add(new DataFlavor("text/html; class=java.nio.ByteBuffer; charset=US-ASCII"));
			htmlFlavors.add(new DataFlavor("text/html; class=\"[B\"; charset=US-ASCII"));
//			htmlFlavors.add(new DataFlavor("text/html; class=java.lang.String"));
//			htmlFlavors.add(new DataFlavor("text/html;class=java.io.Reader"));
//			htmlFlavors.add(new DataFlavor("text/html;charset=unicode;class=java.io.InputStream"));
//			htmlFlavors.add(new DataFlavor("text/html"));
		}
		catch (ClassNotFoundException ex)
		{
			ex.printStackTrace();
		}
	}
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private String html;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTOR
	/* ======================================== */
	
	public HtmlTransferable () 
	{
		this(null);
	}
	
	public HtmlTransferable (String html)
	{
		setHtml(html);
	}
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	public void setHtml (String html)
	{
		if (html == null)
			this.html = "";
		else
			this.html = html;
	}
	
	public String getHtml ()
	{
		return this.html;
	}
	
	public DataFlavor[] getTransferDataFlavors() 
	{
		return (DataFlavor[]) htmlFlavors.toArray(new DataFlavor[htmlFlavors.size()]);
	}
	
	public boolean isDataFlavorSupported(DataFlavor flavor) 
	{
		return htmlFlavors.contains(flavor);
	}
	
	public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException 
	{
		if (String.class.equals(flavor.getRepresentationClass())) 
			return html;
		else if (Reader.class.equals(flavor.getRepresentationClass())) 
			return new StringReader(html);
		else if (InputStream.class.equals(flavor.getRepresentationClass())) 
			return new ByteArrayInputStream(html.getBytes());
		else
			throw new UnsupportedFlavorException(flavor);
	}
} 
