/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.controller.document.writer;

import com.sun.star.lang.EventObject;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseBroadcaster;
import com.sun.star.util.XCloseListener;

public class CloseListener implements XCloseListener{

	
	private boolean bQuit = true;
	private XCloseBroadcaster xCB;

	public CloseListener(){
		bQuit = false;
	}
	
	public void notifyClosing(EventObject arg0) {
		bQuit = true;
	}

	public void queryClosing(EventObject arg0, boolean arg1)
			throws CloseVetoException {
	}

	public void disposing(EventObject arg0) {
		xCB.removeCloseListener(this);
	}

	public boolean isBQuit() {
		return bQuit;
	}

	public void setXCB(XCloseBroadcaster xCB) {
		this.xCB = xCB;
	}

	public void setBQuit(boolean quit) {
		bQuit = quit;
	}


	
}
