/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.controller.document.writer;

import lu.tudor.santec.gecamed.core.gui.controller.data.State;
import lu.tudor.santec.gecamed.core.gui.controller.document.DocumentController;

import com.sun.star.document.XEventBroadcaster;

public class SaveListener implements com.sun.star.document.XEventListener{
	
	private State state;
	private XEventBroadcaster xEVB;
	private DocumentController controller;

	public SaveListener(State state, DocumentController controller){
		this.state=state;
		this.controller = controller;
	}
	
	public void notifyEvent(com.sun.star.document.EventObject e) 
	{
		boolean saveEvent	= false;
		
		
		if (e.EventName.equalsIgnoreCase("OnSaveAs"))
			saveEvent	= true;
		else if (e.EventName.equalsIgnoreCase("OnSaveAsDone"))
			saveEvent	= true;
		else if (e.EventName.equalsIgnoreCase("OnSave"))
			saveEvent	= true;
		else if (e.EventName.equalsIgnoreCase("OnSaveDone"))
			saveEvent	= true;
		
		if (saveEvent)
		{
			state.setSaved(true);
			controller.checkIfContainsContactInfo();
		}
	}

	public void disposing(com.sun.star.lang.EventObject arg0) {
		xEVB.removeEventListener(this);
	}

	public void setXEVB(XEventBroadcaster xEVB) {
		this.xEVB = xEVB;
	}

}
