/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.listener;

import java.util.HashMap;

/**
 * @author martin.heinemann@tudor.lu
 * 29.02.2008
 * 10:27:33
 *
 *
 * @version
 * <br>$Log: EntryTypeRegister.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-03-06 15:34:26  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class EntryTypeRegister {

	
	public static HashMap<String, IEntryTypeHandler> entryTypeHandler = new HashMap<String, IEntryTypeHandler>();
	
	
	public EntryTypeRegister() {
		/* ================================================== */

		/* ================================================== */
	}
	
	
	/**
	 * Add a handler for an entry type.
	 * 
	 * @param entryType name of the type
	 * @param handler the handler
	 */
	public static void registerHandler(String entryType, IEntryTypeHandler handler) {
		/* ================================================== */
		entryTypeHandler.put(entryType, handler);
		/* ================================================== */
	}
	
	/**
	 * @param entryTypeName
	 * @return
	 */
	public static IEntryTypeHandler getHandler(String entryTypeName) {
		/* ================================================== */
		return entryTypeHandler.get(entryTypeName);
		/* ================================================== */
	}
	
}
