/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.listener;

import java.util.Collection;
import java.util.HashMap;

import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;

/**
 * 
 * This interface offers methods for the history component
 * to retrieve specialisations of IncidentEntry object and
 * their special renderer for this kind of objects.
 * 
 * @author martin.heinemann@tudor.lu
 * 29.02.2008
 * 10:37:05
 *
 *
 * @version
 * <br>$Log: IEntryTypeHandler.java,v $
 * <br>Revision 1.6  2013-02-05 13:15:18  ferring
 * <br>letter status added
 * <br>
 * <br>Revision 1.5  2009-05-06 15:58:51  heinemann
 * <br>added method to generate printable output of the incident entrys
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-04-09 09:39:43  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-03-20 16:08:14  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-03-06 15:34:26  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public interface IEntryTypeHandler {
	
	
	/**
	 * Get all entries of the type and the patient
	 * 
	 * @param entryType name of the entry type
	 * @param patientId the patient id
	 * @return a HashMap containg the entryId as key and the object as value
	 */
	public abstract HashMap<Integer, Object> getSpecialEntries(String entryType, Integer patientId);
	
	
	/**
	 * Returns the renderer for that special kind of entry entry.
	 * 
	 * @param entryType
	 * @return
	 */
	public abstract TableCellRenderer getRenderer(String entryType);
	
	
	
	/**
	 * Default action for the entry type
	 * @param entry
	 * @return false if the handler will not handle the request.
	 */
	public abstract boolean openEntry(IncidentEntry entry);
	
	
	/**
	 * Returns a list of all supplied actions, including the defaultaction. 
	 * This actions will be put as JMenuItems into the popup.<br> 
	 * These actions will only be taken, if getPopup returns <code>null</code>.
	 * 
	 * @param entry The selected IncidentEntry
	 * @return The actions for the popup to show on right click
	 */
	public abstract Collection<Action> getActions (IncidentEntry entry);
	
	/**
	 * You have the option to create your own popup. Else you can use the 
	 * getAction method, to make GECAMed create a popup menu out of the
	 * returned actions.
	 * 
	 * @param entry The selected IncidentEntry
	 * @return The popup to show on right click
	 */
	public JPopupMenu getPopup (IncidentEntry entry);
	
	public IEntryPrintRenderer getPrintRenderer(String entryType);
}
