package lu.tudor.santec.gecamed.core.gui.plugin.filehandler;

import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.IncidentManagerBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ChangeFileDescriptionDialog.java,v $
 * <br>Revision 1.1  2014-02-17 14:04:31  ferring
 * <br>Editing file entries by clicking removed, context menu option to edit description and file name added instead
 * <br>
 */

public class ChangeFileDescriptionDialog extends GECAMedBaseDialogImpl implements CaretListener
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private static ChangeFileDescriptionDialog	instance;
	
	
	private IncidentEntry	fileEntry;
	
	// Components
	private JTextField		fileNameField;
	private JTextArea		fileDescriptionArea;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	private ChangeFileDescriptionDialog ()
	{
		super(MainFrame.getInstance(),
				Translatrix.getTranslationString("History.changeFileDescription.dialogTitle"),
				OK_CANCEL_BUTTON_MODE);
		
		initComponents();
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public static void showDialog (IncidentEntry fileEntry)
	{
		ChangeFileDescriptionDialog dialog = getInstance();
		
		
		dialog.refresh(fileEntry);
		
		dialog.pack();
		dialog.showCenteredDialog();
		
		if (dialog.getButtonOption() == OK_OPTION && dialog.hasChanges())
			dialog.saveChanges();
	}
	
	
	public boolean hasChanges ()
	{
		return !fileNameField.getText().equals(fileEntry.getOriginalFilename())
				|| !fileDescriptionArea.getText().equals(fileEntry.getTextContent());
	}
	
	
	public void caretUpdate (CaretEvent e)
	{
		okButton.setEnabled(hasChanges());
	}
	
	
	
	/* ======================================== */
	// HELP METHODS
	/* ======================================== */
	
	private static ChangeFileDescriptionDialog getInstance ()
	{
		if (instance == null)
			instance = new ChangeFileDescriptionDialog();
		
		return instance;
	}
	
	
	private void initComponents ()
	{
		JLabel			fileNameLabel;
		JLabel			fileDescriptionLabel;
		JScrollPane		fileDescriptionScroller;
		CellConstraints	cc	= new CellConstraints();
		
		
		fileNameLabel			= new JLabel(Translatrix.getTranslationString("History.changeFileDescription.nameLabel"));
		fileNameField			= new JTextField();
		fileNameField.addCaretListener(this);
		
		fileDescriptionLabel	= new JLabel(Translatrix.getTranslationString("History.changeFileDescription.descriptionLabel"));
		fileDescriptionArea		= new JTextArea();
		fileDescriptionArea.addCaretListener(this);
		fileDescriptionScroller	= new JScrollPane(fileDescriptionArea);
		fileDescriptionScroller.setOpaque(false);
		fileDescriptionScroller.getViewport().setOpaque(false);
		
		mainPanel.setLayout(new FormLayout(
				// columns
				"5px, f:p:g, 5px", 
				// rows
				  " 5px,f:p,"	// file name label
				+ " 5px,f:p,"	// file name text field
				+ " 5px,f:p,"	// file description label
				+ " 5px,f:100px:g,"	// file description field
				+ " 5px"));
		
		mainPanel.add(fileNameLabel,			cc.xy(2, 2));
		mainPanel.add(fileNameField,			cc.xy(2, 4));
		mainPanel.add(fileDescriptionLabel,		cc.xy(2, 6));
		mainPanel.add(fileDescriptionScroller,	cc.xy(2, 8));
	}
	
	
	private void refresh (IncidentEntry entry)
	{
		fileEntry	= entry;
		
		fileNameField.setText(fileEntry.getOriginalFilename());
		fileDescriptionArea.setText(fileEntry.getTextContent());
		okButton.setEnabled(false);
	}
	
	
	private void saveChanges ()
	{
		IncidentManager	manager	= (IncidentManager) ManagerFactory.getRemote(IncidentManagerBean.class);
		
		
		fileEntry.setOriginalFilename(fileNameField.getText());
		fileEntry.setTextContent(fileDescriptionArea.getText());
		
		manager.saveEntry(fileEntry, null);
		PatientManagerModule.getInstance().getPatientPanel().reloadHistory();
	}
}
