/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: ImageViewHandler.java,v $
 * <br>Revision 1.6  2013-02-08 15:27:16  ferring
 * <br>Option added for files and letters to attach them to another incident
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-04-09 09:39:43  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-03-20 16:08:14  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-01-28 08:27:08  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007-12-17 14:59:59  heinemann
 * <br>plugins and file store and open
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.core.gui.plugin.filehandler;

import ij.ImagePlus;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.swing.AbstractAction;
import javax.swing.Action;

import lu.tudor.santec.gecamed.cara.gui.DicomImageDialog;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.plugin.IFileHandler;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.gui.history.FileHandler;
import lu.tudor.santec.gecamed.patient.gui.history.contextmenu.ChangeIncidentAction;
import lu.tudor.santec.i18n.Translatrix;

/**
 * 
 * Can show images like jpeg, tiff, etc.
 * 
 * @author martin.heinemann@tudor.lu
 * 07.12.2007
 * 14:40:59
 *
 *
 * @version
 * <br>$Log: ImageViewHandler.java,v $
 * <br>Revision 1.6  2013-02-08 15:27:16  ferring
 * <br>Option added for files and letters to attach them to another incident
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-04-09 09:39:43  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-03-20 16:08:14  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-01-28 08:27:08  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007-12-17 14:59:59  heinemann
 * <br>plugins and file store and open
 * <br>
 *   
 */
public class ImageViewHandler implements IFileHandler {
	
	
	
	private DicomImageDialog imageViewerDialog;
	private ImagePlus image;
	private AbstractAction defaultAction;
	private AbstractAction changeIncidentAction;
	private ArrayList<Action> actionList;
	private HashSet<String> extensions;
	private HashSet<String> mimetypes;
//	private IncidentEntry currentIncidentEntry;

	public ImageViewHandler() {
		/* ================================================== */
		this.imageViewerDialog = new DicomImageDialog(MainFrame.getInstance());
		
		initDefaultAction();
		/* ------------------------------------------------------- */
		// actions
		/* ------------------------------------------------------- */
		this.actionList = new ArrayList<Action>();
		actionList.add(defaultAction);
		actionList.add(changeIncidentAction);
		
		/* ------------------------------------------------------- */
		// extensions
		/* ------------------------------------------------------- */
		this.extensions = new HashSet<String>();
		extensions.add(FileHandler.EXT_BMP);
		extensions.add(FileHandler.EXT_TIFF);
		extensions.add(FileHandler.EXT_JPEG);
		extensions.add(FileHandler.EXT_JPG);
		extensions.add(FileHandler.EXT_PNG);
		extensions.add(FileHandler.EXT_GIF);
		/* ------------------------------------------------------- */
		// mimetypes
		/* ------------------------------------------------------- */
		this.mimetypes = new HashSet<String>();
		mimetypes.add(FileHandler.MIME_BMP);
		mimetypes.add(FileHandler.MIME_GIF);
		mimetypes.add(FileHandler.MIME_JPG);
		mimetypes.add(FileHandler.MIME_PNG);
		mimetypes.add(FileHandler.MIME_TIFF);
		/* ================================================== */
	}
	

	/**
	 * Show image 
	 */
	public void defaultAction() {
		/* ====================================================== */
		this.defaultAction.actionPerformed(null);
		/* ====================================================== */
	}

	/**
	 * 
	 */
	public List<Action> getActions(IncidentEntry entry) {
		/* ====================================================== */
//		this.currentIncidentEntry = entry;
		return actionList;
		/* ====================================================== */
	}

	/**
	 * 
	 */
	public Set<String> getSupportedExtensions() {
		/* ====================================================== */
		return extensions;
		/* ====================================================== */
	}

	/**
	 * 
	 */
	public Set<String> getSupportedMimetypes() {
		/* ====================================================== */
		return mimetypes;
		/* ====================================================== */
	}

	/**
	 * 
	 */
	public void setFile(URL fileUrl) {
		/* ====================================================== */
//		if (fileUrl == null) {
//			this.image = null;
//			return;
//		}
//		/* ------------------------------------------------------- */
//		ImagePlus i = new ImagePlus(file.getAbsolutePath());
//		this.image = i;
		/* ====================================================== */
	}

	/**
	 * 
	 */
	public void setFile(byte[] binaryData, String filename) {
		/* ====================================================== */
		try {
			/* ------------------------------------------------------- */
			File tempF = File.createTempFile("gecamed", ".image");
			
			FileOutputStream fout = new FileOutputStream(tempF);
			fout.write(binaryData);
			fout.close();
			this.image = new ImagePlus(tempF.getAbsolutePath());
			/* ------------------------------------------------------- */
		} catch (Exception e) {
			e.printStackTrace();
		}
		/* ====================================================== */
	}

	
	/**
	 * 
	 */
	private void initDefaultAction() {
		/* ================================================== */
		this.defaultAction = new AbstractAction(Translatrix.getTranslationString("plugin.file.viewer.showImage")
				, GECAMedModule.getSmallIcon(GECAMedIconNames.OPEN)) {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e) {
				/* ====================================================== */
//				setFile(FileHandler.loadBinary(currentIncidentEntry), currentIncidentEntry.getFileName());
				if (image != null) {
					imageViewerDialog.showImage(image);
				}
				/* ====================================================== */
			}
		};
		this.changeIncidentAction = ChangeIncidentAction.getInstance();
		/* ================================================== */	
	}
	
	
}
