/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: DemoEmailDialog.java,v $
 * <br>Revision 1.6  2008-12-05 17:34:23  heinemann
 * <br>moved some basic classes to lu.tudor.santec.widgets
 * <br>
 * <br>Revision 1.5  2008-11-12 17:16:33  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-03-11 17:17:11  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2007-11-20 08:58:55  hermen
 * <br>moved Managerfactory to core.utils and refactured code to use ManagerFactory instead of context.lookup
 * <br>
 * <br>Revision 1.1  2007-10-24 15:16:53  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.core.gui.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.EMailField;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedInfo;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.LoginInterface;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.widgets.gui.form.FormPanel;

import com.jgoodies.forms.builder.ButtonBarBuilder;

/**
 * @author martin.heinemann@tudor.lu
 * 24.10.2007
 * 13:34:15
 *
 *
 * @version
 * <br>$Log: DemoEmailDialog.java,v $
 * <br>Revision 1.6  2008-12-05 17:34:23  heinemann
 * <br>moved some basic classes to lu.tudor.santec.widgets
 * <br>
 * <br>Revision 1.5  2008-11-12 17:16:33  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-03-11 17:17:11  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2007-11-20 08:58:55  hermen
 * <br>moved Managerfactory to core.utils and refactured code to use ManagerFactory instead of context.lookup
 * <br>
 * <br>Revision 1.1  2007-10-24 15:16:53  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class DemoEmailDialog extends GECAMedBaseDialog implements ActionListener {
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public static final String EMAIL_LIST = "EMAIL_LIST";
	
	private EMailField emailField;
	private JTextField nameField;
	private JButton closeButton;


	/**
	 * @param title
	 */
	private DemoEmailDialog(String title) {
		/* ================================================== */
		super(title, false);
		/* ================================================== */
	}

	public DemoEmailDialog() {
		/* ================================================== */
		this(Translatrix.getTranslationString("core.demo"));
		this.showHeader(true);
		/* ------------------------------------------------------- */
		this.setHeaderIcon(GECAMedModule.getIcon(GECAMedIconNames.INFO));
		this.setHeaderTitle(Translatrix.getTranslationString("core.demo"));
		/* ------------------------------------------------------- */
		
//		JLabel mainInfoLabel = new JLabel(Translatrix.getTranslationString("core.demoMessage"));
		this.nameField  = new JTextField(30);
		this.emailField = new EMailField(30);
		/* ------------------------------------------------------- */
		FormPanel fPanel = new FormPanel();
		fPanel.setOpaque(false);
		fPanel.addTextBlock("<html>"+Translatrix.getTranslationString("core.demoMessage")).setBorder(null);
		fPanel.addSeparator();
		fPanel.addGap();
		fPanel.addTextBlock(Translatrix.getTranslationString("core.emailMessage")).setBorder(null);
		fPanel.addGap();
		
		fPanel.addLine(Translatrix.getTranslationString("core.name"),  nameField);
		fPanel.addLine(Translatrix.getTranslationString("core.email"), emailField);
		/* ------------------------------------------------------- */
		// Closebutton
		this.closeButton = new JButton(Translatrix.getTranslationString("core.ok"),
										GECAMedModule.getMediumIcon(GECAMedIconNames.OK));
		closeButton.addActionListener(this);
		/* ------------------------------------------------------- */
		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addUnrelatedGap();
		bb.addGlue();
		bb.addGridded(closeButton);
		bb.addGlue();
		bb.addUnrelatedGap();
		
		
		bb.getPanel().setOpaque(true);
		bb.getPanel().setBackground(Color.WHITE);
		bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		/* ------------------------------------------------------- */
		
		
		this.addMainPanel(fPanel);
		this.add(bb.getPanel(), BorderLayout.SOUTH);
		/* ================================================== */
	}
	
	public void showDialog() {
		/* ================================================== */
		this.pack();
		this.setSize(this.getWidth(), this.getHeight()+150);
		MainFrame.showDialogCentered(this);
		/* ================================================== */
	}
	

	public void actionPerformed(ActionEvent e) {
		/* ====================================================== */
		// get infos from fields
		/* ------------------------------------------------------- */
		StringBuffer buff = new StringBuffer();
		/* ------------------------------------------------------- */
		if (this.nameField.getText() != null && !"".equals(this.nameField.getText()))
			buff.append("\""+nameField.getText()+"\" ");
//		if (this.emailField.getText() != null && !"".equals(this.emailField.getText())) {
		if (emailField.isAddressValid()) {
			/* ------------------------------------------------------- */
			if ("".equals(buff.toString().trim()))
				buff.append("\""+emailField.getText()+"\" ");
			buff.append("<"+emailField.getText()+">");
			/* ------------------------------------------------------- */
			// save in database
			try {
				/* ------------------------------------------------------- */
				LoginInterface lManager = (LoginInterface) 
					ManagerFactory.getRemote(ManagerFactory.LOGINBEAN);
				/* ------------------------------------------------------- */
				GecamedInfo info = null;
				try {
				info = lManager.getInfo(EMAIL_LIST);
				} catch (Exception e2) {}
				
				if (info == null) {
					info = new GecamedInfo();
					info.setKey(EMAIL_LIST);
					info.setValue("");
					info.setDate(new Date());
				}
				/* ------------------------------------------------------- */
				// set the data
				if (info.getValue() == null)
					info.setValue("");
				/* ------------------------------------------------------- */
				info.setValue(info.getValue()+buff.toString()+",\n");
				/* ------------------------------------------------------- */
				lManager.setInfo(info);
				/* ------------------------------------------------------- */
			} catch (Exception e1) {
				e1.printStackTrace();
			}
			/* ------------------------------------------------------- */
		} 
		/* ------------------------------------------------------- */
		// just close
		this.setVisible(false);
		/* ------------------------------------------------------- */
		/* ====================================================== */
	}

}
