/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.utils;
/* FilePrintHelper.java */
 
 import java.util.Vector;
 
 public class FilePrintHelper
 {
   //---Membervariablen----------------------------------
   Vector pageinfo;
 
   //---Konstruktor--------------------------------------
   public FilePrintHelper()
   {
     pageinfo = new Vector();
   }
 
   //---Seitendefinition und -abfrage--------------------
   @SuppressWarnings("unchecked")
public void createPage(int page)
   {
     for (int i = pageinfo.size(); i <= page; ++i) {
       pageinfo.addElement(new Entry());
     }
   }
 
   public boolean knownPage(int page)
   {
     return page < pageinfo.size();
   }
 
   //---Verwaltung der Offsets---------------------------
   public long getFileOffset(int page)
   {
     Entry entry = (Entry)pageinfo.elementAt(page);
     return entry.fileoffset;
   }
 
   public void setFileOffset(int page, long fileoffset)
   {
     Entry entry = (Entry)pageinfo.elementAt(page);
     entry.fileoffset = fileoffset;
   }
 
   //---Lokale Klasse Entry------------------------------
   static class Entry
   {
     public long fileoffset;
 
     public Entry()
     {
       this.fileoffset = -1;
     }
   }
   
   public int getPages() {
       return pageinfo.size();
   }
   
 }
