/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;

/**
 * Universal Focustraversal policy for gecamed.
 * Just create a new instance and add the components in the order you
 * want to have the focus cycled.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 16.04.2008
 * 10:54:59
 *
 *
 * @version
 * <br>$Log: GECAMedFocusTraversalPolicy.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-04-16 14:24:28  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class GECAMedFocusTraversalPolicy extends FocusTraversalPolicy{
	
	private List<Component> focusComponents = new ArrayList<Component>();
	
	public GECAMedFocusTraversalPolicy() {
		/* ================================================== */
		
		/* ================================================== */
	}
	
	/**
	 * Add a component to the focus cycle
	 * 
	 * @param component
	 */
	public void add(Component component) {
		/* ================================================== */
		focusComponents.add(component);
		/* ------------------------------------------------------- */
		component.setFocusable(true);
		/* ================================================== */
	}
	
	
	public void add(List<Component> componentList) {
		/* ================================================== */
		if (componentList == null)
			return;
		/* ------------------------------------------------------- */
		for (Component c : componentList)
			add(c);
		/* ================================================== */
	}
	
	/**
	 * Removes a component from the focus cycle
	 * 
	 * @param component
	 */
	public void remove(Component component) {
		/* ================================================== */
		focusComponents.remove(component);
		/* ================================================== */
	}
	
	
	@Override
	public Component getComponentAfter(Container aContainer, Component aComponent) {
		/* ====================================================== */
		int current = focusComponents.indexOf(aComponent);
		/* ------------------------------------------------------- */
		// if the component is not in the arraylist, return null
		/* ------------------------------------------------------- */
		if (current < 0) {
			/* ------------------------------------------------------- */
			Container parent = aComponent.getParent();
			int pos = -1;
			do {
				/* ------------------------------------------------------- */
				pos = focusComponents.indexOf(parent);
				parent = parent.getParent();
				/* ------------------------------------------------------- */
			} while (parent.getParent() != null && pos < 0);
			current = pos;
			/* ------------------------------------------------------- */
			if (current < 0)
				return null;
			/* ------------------------------------------------------- */
		}

		/* ------------------------------------------------------- */
		current++;
		if (current > focusComponents.size()-1)
			return null;
		/* ------------------------------------------------------- */
		return focusComponents.get(current);
		/* ====================================================== */
	}

	@Override
	public Component getComponentBefore(Container aContainer, Component aComponent) {
		/* ====================================================== */
		int current = focusComponents.indexOf(aComponent);
		/* ------------------------------------------------------- */
		// if the component is not in the arraylist, return null
		/* ------------------------------------------------------- */
		current--;
		if (current < 0)
			return null;
		/* ------------------------------------------------------- */
		return focusComponents.get(current);
		/* ====================================================== */
	}

	@Override
	public Component getDefaultComponent(Container aContainer) {
		/* ====================================================== */
		return getFirstComponent(aContainer);
		/* ====================================================== */
	}

	@Override
	public Component getFirstComponent(Container aContainer) {
		/* ====================================================== */
		try {
			/* --------------------------------------------- */
			return focusComponents.get(0);
			/* --------------------------------------------- */
		} catch (Exception e) {
			/* --------------------------------------------- */
			return null;
			/* --------------------------------------------- */
		}
		/* ====================================================== */
	}

	@Override
	public Component getLastComponent(Container aContainer) {
		/* ====================================================== */
		try {
			/* --------------------------------------------- */
			return focusComponents.get(focusComponents.size()-1);
			/* --------------------------------------------- */
		} catch (Exception e) {
			/* --------------------------------------------- */
			return null;
			/* --------------------------------------------- */
		}
		/* ====================================================== */
	}

}
