/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.utils;

import java.awt.Color;

import javax.swing.JComponent;
import javax.swing.JPanel;

import bizcal.swing.util.GradientArea;
import bizcal.swing.util.GradientPanel;


/**
 * Creates gradient panels. Just give me your component and everything is done
 * automatically.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 21.12.2007
 * 13:11:45
 *
 *
 * @version
 * <br>$Log: GradientFactory.java,v $
 * <br>Revision 1.5  2009-01-19 15:57:57  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-05-08 09:10:02  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-01-21 16:25:36  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-01-02 13:39:22  heinemann
 * <br>initial checkin
 * <br>
 *   
 */
public class GradientFactory {
	
	
	// ========================================================================
	// Class constants
	// ========================================================================	
	public static final Color BLUE_BACK    = new Color(226, 235, 255);
	public static final Color LIGHT_BACK   = new Color(237, 242, 251);
	public static final Color LIGHT_BORDER = new Color(163, 184, 204);
	public static final Color DARK_BACK    = new Color(184, 207, 229);
	

	/**
	 * Creates a Gradient Panel with the colors
	 * SimpleViewPanel.DARK_BACK, Color.WHITE
	 * and direction BOTTOM_TOP
	 * 
	 * @param panel
	 * @return
	 */
	public static JPanel makeGradient(JComponent panel) {
		/* ================================================== */
		return makeGradient(panel, GradientArea.BOTTOM_TOP, DARK_BACK, Color.WHITE);
		/* ================================================== */
	}
	
	/**
	 * Creates a Gradient Panel with the colors
	 * DARK_BACK, Color.WHITE
	 * and direction as specified
	 * 
	 * @param panel
	 * @param direction use GradientArea.TOP_BOTTOM etc
	 * @return
	 */
	public static JPanel makeGradient(JComponent panel, String direction) {
		/* ================================================== */
		return makeGradient(panel, direction, DARK_BACK, Color.WHITE);
		/* ================================================== */
	}
	
	
	/**
	 * Creates a GradientPanel with direction BOTTOM_TOP
	 * 
	 * @param panel
	 * @param dark
	 * @param light
	 * @return
	 */
	public static JPanel makeGradient(JComponent panel, Color dark, Color light) {
		/* ================================================== */
		return makeGradient(panel, GradientArea.BOTTOM_TOP, dark, light);
		/* ================================================== */
	}
	
	public static JPanel makeGradient(JComponent panel, Color dark) {
		/* ================================================== */
		return makeGradient(panel, GradientArea.BOTTOM_TOP, dark, Color.WHITE);
		/* ================================================== */
	}
	
	/**
	 * Uses the colorspace of the given color.
	 * 
	 * @param panel
	 * @param dark
	 * @param colorSpace
	 * @return
	 */
	public static JPanel makeGradient(JComponent panel, Color dark, boolean colorSpace) {
		/* ================================================== */
		if (colorSpace) {
			Color darker =  new Color(darker(dark.getRed()), darker(dark.getGreen()), darker(dark.getBlue()));
			Color lighter = new Color(lighter(dark.getRed()), lighter(dark.getGreen()), lighter(dark.getBlue()));
			
			return makeGradient(panel, GradientArea.BOTTOM_TOP, darker, lighter);
		} 
		return makeGradient(panel, GradientArea.BOTTOM_TOP, dark, Color.WHITE);
		/* ================================================== */
	}
	
	/**
	 * @param panel
	 * @param direction
	 * @param dark
	 * @return
	 */
	public static JPanel makeGradient(JComponent panel, String direction, Color dark) {
		/* ================================================== */
		return makeGradient(panel, direction, dark, Color.WHITE);
		/* ================================================== */
	}
	
	/**
	 * @param panel
	 * @param direction
	 * @param dark
	 * @param light
	 * @return
	 */
	public static JPanel makeGradient(JComponent panel, String direction, Color dark, Color light) {
		/* ================================================== */
		GradientArea gradientArea = new GradientArea(direction, dark, light);
		gradientArea.setBorderWidth(0.0f);
		
		panel.setOpaque(false);
		JPanel gradientToppanel = new GradientPanel(gradientArea, panel);
		return gradientToppanel;
		/* ================================================== */
	}
	
	
	
	/**
	 * Lighter, 255 if out of range
	 * 
	 * @param color
	 * @param offset
	 * @return
	 */
	private static int lighter(int color) {
		/* ================================================== */
		int max = 255;
		int offset = 140;
		/* ------------------------------------------------------- */
		if (color >= max)
			return max;
		/* ------------------------------------------------------- */
		if (color + offset > max)
			return max;
		/* ------------------------------------------------------- */
		return color + offset;
		/* ================================================== */
	}
	
	/**
	 * makes darker color, returns 0 if out of range
	 * 
	 * @param color
	 * @param offset
	 * @return
	 */
	private static int darker(int color) {
		/* ================================================== */
		int min = 0;
		int offset = 30;
		/* ------------------------------------------------------- */
		if (color < min)
			return min;
		/* ------------------------------------------------------- */
		if (color - offset < min)
			return min;
		/* ------------------------------------------------------- */
		return color - offset;
		/* ================================================== */
	}
	
}
