package lu.tudor.santec.gecamed.core.gui.utils;

import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

import com.toedter.calendar.JDateChooser;
import com.toedter.calendar.JDateChooserCellEditor;
import com.toedter.calendar.JTextFieldDateEditor;

public class JDateChooserCellEditorGECAMed extends JDateChooserCellEditor {

	private static final long serialVersionUID = 917881575221755609L;

	private JDateChooser dateChooser = GECAMedGuiUtils.getDateChooser(false);
	private SimpleDateFormat df = new SimpleDateFormat(GECAMedGuiUtils.getDateFormatString(false));

	public Component getTableCellEditorComponent(JTable table, Object value,
			boolean isSelected, int row, int column) {

		Date date = null;
		if (value instanceof Date)
			date = (Date) value;

		dateChooser.setDate(date);

		return dateChooser;
	}

	public Object getCellEditorValue() {
		try {
			String dateText = ((JTextFieldDateEditor)dateChooser.getDateEditor()).getText();
			Calendar c = new GregorianCalendar();
			c.setTime(df.parse(dateText));
			if (c.get(Calendar.YEAR) < 100) {
				c.add( Calendar.YEAR, 2000);
				dateChooser.setDate(c.getTime());
			}								
		} catch (Exception e) {
			System.out.println("unable to parse date");
		}
		return dateChooser.getDate();
	}
}