/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;

public class LineColorCellRenderer extends DefaultTableCellRenderer {

	//**************************************************************************
	// *
	// * Class Constants *
	//**************************************************************************
	// *

	private static final long serialVersionUID = 1L;

	public Color c_OddColor;
	public Color c_EvenColor;

	private Font textFont;

	private int alignment;

	public LineColorCellRenderer() {
//		c_OddColor = new Color(237, 243, 254);
//		c_EvenColor = new Color(255, 255, 255);
		this(false);
		
	}
	
	/**
	 * 
	 * @param invertColors true = start with white background
	 */
	public LineColorCellRenderer(boolean invertColors) {
		/* ================================================== */
		if (invertColors) {
			/* ------------------------------------------------------- */
//			c_EvenColor = new Color(237, 243, 254);
			c_EvenColor = GECAMedColors.c_OddLineBackground;
//			c_OddColor = new Color(255, 255, 255);
			c_OddColor = GECAMedColors.c_EvenLineBackground;
			/* ------------------------------------------------------- */
		} else {
			/* ------------------------------------------------------- */
//			c_OddColor = new Color(237, 243, 254);
			c_OddColor = GECAMedColors.c_OddLineBackground;
//			c_EvenColor = new Color(255, 255, 255);
			c_EvenColor = GECAMedColors.c_EvenLineBackground;
			/* ------------------------------------------------------- */
		}
		/* ================================================== */
	}
	
	public LineColorCellRenderer(int alignment) {
		c_OddColor = GECAMedColors.c_OddLineBackground;
		c_EvenColor = GECAMedColors.c_EvenLineBackground;
		this.setHorizontalAlignment(alignment);
	}

	public LineColorCellRenderer(int alpha, Font font, boolean centerText) {
		c_OddColor = GECAMedColors.c_OddLineBackground;
		c_EvenColor = GECAMedColors.c_EvenLineBackground;
		this.textFont = font;
		if (centerText) {
			this.setHorizontalAlignment(JLabel.CENTER);
			alignment = JLabel.CENTER;			
		}
	}
	
	public LineColorCellRenderer(int alpha, Font font, int alignment) {
		c_OddColor = GECAMedColors.c_OddLineBackground;
		c_EvenColor = GECAMedColors.c_EvenLineBackground;
		this.textFont = font;
		this.setHorizontalAlignment(alignment);
	}
	
	

	public Component getTableCellRendererComponent(JTable p_Table, Object value, boolean p_IsSelected,
			boolean hasFocus, int p_Row, int p_Column) {
		/* ------------------------------------------------------- */
		super.getTableCellRendererComponent(p_Table, value, p_IsSelected,
				hasFocus, p_Row, p_Column);
		Color l_Background;
		
		
		l_Background = (p_Row % 2 == 0) ? c_OddColor : c_EvenColor;
		if (p_IsSelected)
			this.setBackground(p_Table.getSelectionBackground());
		else
			this.setBackground(l_Background);

		if (textFont != null)
			this.setFont(textFont);

//		if (centerText)
//			this.setHorizontalAlignment(JLabel.CENTER);

		if(p_Table.getColumnCount() >= p_Column) {
			setSize(p_Table.getColumnModel().getColumn(p_Column).getWidth(),
				getPreferredSize().height);
		}

		if (p_Table.getRowHeight(p_Row) < getPreferredSize().height) {
			p_Table.setRowHeight(p_Row, getPreferredSize().height);
		}
		
		return this;
	}
}
