/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.utils;

import java.awt.Color;
import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;

public class LineColorListRenderer extends DefaultListCellRenderer {

	// ***************************************************************************
	// * Class Constants *
	// ***************************************************************************

	private static final long serialVersionUID = 1L;

	public LineColorListRenderer() {
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see javax.swing.DefaultListCellRenderer#getListCellRendererComponent(javax.swing.JList,
	 *      java.lang.Object, int, boolean, boolean)
	 */
	@Override
	public Component getListCellRendererComponent(JList list, Object value,
			int index, boolean isSelected, boolean cellHasFocus) {
		/* ====================================================== */

		super.getListCellRendererComponent(list, value, index, isSelected,
				cellHasFocus);

		Color l_Background;

		l_Background = (index % 2 == 0) ? GECAMedColors.c_OddLineBackground
											: GECAMedColors.c_EvenLineBackground;
		if (isSelected)
			this.setBackground(list.getSelectionBackground());
		else
			this.setBackground(l_Background);

		return this;
		/* ====================================================== */
	}
}
