/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.utils;

import java.awt.Color;
import java.awt.Component;

import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 * Cellrenderer to display multiple lines of text in a JTable.
 * 
 * use it e.g. with the MultiLineCellEditor
 * 
 * 
 * 
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: MultiLineCellRenderer.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:39  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.1  2007/01/05 13:12:34  heinemann
 * <br>allergy table comments now have a multiline editor
 * <br>
 */
public class MultiLineCellRenderer extends JEditorPane implements TableCellRenderer {

	// ***************************************************************************
	// * Class Constants *
	// ***************************************************************************

	private static final long serialVersionUID = 1L;
	private static final int c_Gap = 2;
	private final static int fontSize = 9;

	public MultiLineCellRenderer() {
		setContentType("text/html");
		this.setBorder(BorderFactory.createEmptyBorder(c_Gap, c_Gap, c_Gap,
				c_Gap));
	}

	public Component getTableCellRendererComponent(JTable p_Table,
			Object value, boolean p_IsSelected, boolean hasFocus, int row,
			int column) {
			/* ------------------------------------------------------ */
			if (value != null && !value.equals(""))
				setText("<html><span style=\"font-family:Arial;font-size:"
						+ fontSize + "px;\">"
						+ ((String) value).replaceAll("\n", "<br>"));
			else
				setText("");
			
			setSize(p_Table.getColumnModel().getColumn(column).getWidth(),
					getPreferredSize().height);
	
			if (p_Table.getRowHeight(row) < getPreferredSize().height) {
				p_Table.setRowHeight(row, getPreferredSize().height);
			}
			
			if (p_IsSelected)
				this.setBackground(p_Table.getSelectionBackground());
			else
				this.setBackground(Color.WHITE);
			return this;
			
			/* ------------------------------------------------------ */
	}
}
