/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.utils;

import java.util.Collection;
import java.util.Vector;

import javax.swing.AbstractListModel;

/**
 * A simple model for JLists.
 * It uses a Vector as datasink.
 * 
 * @author martin.heinemann@tudor.lu
 * 27.08.2008
 * 09:50:15
 *
 *
 * @version
 * <br>$Log: SimpleListModel.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-08-27 15:34:53  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class SimpleListModel<T> extends AbstractListModel {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	
	private Vector<T> dataVector = new Vector<T>();
	
	
	/**
	 * 
	 */
	public SimpleListModel() {
		/* ================================================== */

		/* ================================================== */
	}
	
	
	public T getElementAt(int index) {
		/* ====================================================== */
		if (dataVector == null || index < 0 || index > dataVector.size()-1)
			return null;
		
		return dataVector.get(index);
		/* ====================================================== */
	}

	public int getSize() {
		/* ====================================================== */
		if (dataVector == null)
			return 0;
		return dataVector.size();
		/* ====================================================== */
	}
	
	/**
	 * Clears the data and fires update
	 */
	public void clear() {
		/* ================================================== */
		this.dataVector.clear();
		fireContentsChanged(this, 0, 0);
		/* ================================================== */
	}
	
	/**
	 * Sets the new data and fires update
	 * 
	 * @param newData
	 */
	public void setData(Collection<T> newData) {
		/* ================================================== */
		this.dataVector = new Vector<T>(newData);
		fireContentsChanged(this, 0, dataVector.size()-1);
		/* ================================================== */
	}
	
	
	/**
	 * Adds an item to the list
	 * 
	 * @param item
	 */
	public void addItem(T item) {
		/* ================================================== */
		this.dataVector.add(item);
		fireContentsChanged(this, 0, dataVector.size()-1);
		/* ================================================== */
	}
	
	/**
	 * Removes an item from the list
	 * @param item
	 */
	public void removeItem(T item) {
		/* ================================================== */
		this.dataVector.remove(item);
		fireContentsChanged(this, 0, dataVector.size()-1);
		/* ================================================== */
	}
	
	/**
	 * @return
	 */
	public Vector<T> getData() {
		/* ================================================== */
		return this.dataVector;
		/* ================================================== */
	}
	
}
