/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: SystemInfo.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-04-30 08:20:06  heinemann
 * <br>OS X check
 * <br>
 * <br>Revision 1.1  2007-12-12 09:22:30  heinemann
 * <br>initial checkin
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.core.gui.utils;

/**
 * 
 * Static class to retriev system specific information like
 * the type of the operating system
 * 
 * @author martin.heinemann@tudor.lu
 * 12.12.2007
 * 09:00:45
 *
 *
 * @version
 * <br>$Log: SystemInfo.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-04-30 08:20:06  heinemann
 * <br>OS X check
 * <br>
 * <br>Revision 1.1  2007-12-12 09:22:30  heinemann
 * <br>initial checkin
 * <br>
 *   
 */
public class SystemInfo {

	/**
	 * Unknown operating system
	 */
	public static final int SYSTEM_UNKNOWN = 0;
	
	/**
	 * Operating System is any kind of Windows 
	 */
	public static final int SYSTEM_WINDOWS = 1;
	
	/**
	 * Operating System is any kind of Linux
	 */
	public static final int SYSTEM_LINUX   = 2;
	
	/**
	 * Operating System is MAC OS X (intel and ppc) 
	 */
	public static final int SYSTEM_OSX     = 3;
	
	/**
	 * Operating System is MAC OS (ppc)
	 */
	public static final int SYSTEM_OS     = 4;
	
	
	/**
	 * The current os
	 */
	private static int currentOS = SYSTEM_UNKNOWN;
	
	
	// ####################################################################
	// static block to get the os type. Must be done only once
	//
	// ####################################################################
	static {
		/* ================================================== */
		// try to get the operating system
		String os = System.getProperty("os.name");
		/* ------------------------------------------------------- */
		if (os == null || "".equals(os)) {
			currentOS = SYSTEM_UNKNOWN;
		}
		/* ------------------------------------------------------- */
		// check for windows
		/* ------------------------------------------------------- */
		else if (os.toUpperCase().contains("WIN")) {
			currentOS = SYSTEM_WINDOWS;
		}
		/* ------------------------------------------------------- */
		// check for Linux
		/* ------------------------------------------------------- */
		else if (os.toUpperCase().contains("LINUX")) {
			currentOS = SYSTEM_LINUX;
		}
		/* ------------------------------------------------------- */
		// check for MAC OS X
		/* ------------------------------------------------------- */
		else if (os.toUpperCase().contains("MAC") && os.toUpperCase().contains("OS") && os.toUpperCase().contains("X")) {
			currentOS = SYSTEM_OSX;
		}
		/* ------------------------------------------------------- */
		// check for MAC OS
		/* ------------------------------------------------------- */
		else if (os.toUpperCase().contains("MAC") && os.toUpperCase().contains("OS") && !os.toUpperCase().contains("X")) {
			currentOS = SYSTEM_OS;
		}
		/* ------------------------------------------------------- */
		// else unknown
		/* ------------------------------------------------------- */
		else
			currentOS = SYSTEM_UNKNOWN;
		/* ================================================== */
	}
	
	
	private SystemInfo() {
		/* ================================================== */

		/* ================================================== */
	}
	
	
	
	/**
	 * returns the operating system
	 * from the System.properties.
	 * 
	 * @return Constants for the os SYSTEM_UNKNOWN, SYSTEM_WINDOWS,SYSTEM_LINUX, SYSTEM_OS, SYSTEM_OSX
	 */
	public static int getOperatingSystem() {
		/* ================================================== */
		return currentOS;
		/* ================================================== */
	}
	
	
	
}
