/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;



public class WindowToolbox {

	
	
	public static void showCentered(JFrame parent, JDialog dialog) {
		Dimension f = parent.getSize();
		
		int posX = parent.getX();
		int posY = parent.getY();
		
//    	Point d = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
    	
//		fadeIn(dialog, parent);
		
		dialog.setLocation(posX + (f.width/ 2) - dialog.getSize().width/2 , posY + (f.height / 2) - dialog.getSize().height/2);
		dialog.setVisible(true);
	}
	
	
	/**
	 * Returns the center x coordinate of the component
	 * 
	 * @param component
	 * @return
	 */
	public static int getCenterX(JFrame component) {
		/* ================================================== */
		Dimension f = component.getSize();
		
		int posX = component.getX();
		return posX + (f.width / 2);
		/* ================================================== */
	}
	
	/**
	 * Returns the center y coordinate of the component
	 * 
	 * @param component
	 * @return
	 */
	public static int getCenterY(JFrame component) {
		/* ================================================== */
		Dimension f = component.getSize();
		
		int posY = component.getY();
		return posY + (f.height / 2);
		/* ================================================== */
	}
	
	
	/**
	 * @param dialog
	 */
	public static void fadeIn(final JDialog dialog, JFrame parent) {
		/* ================================================== */
		boolean wasModal = false;
		if (dialog.isModal()) {
			wasModal = true;
			dialog.setModal(false);
		}
		/* ------------------------------------------------------- */
		int finalWidth 	= dialog.getWidth();
		int finalHeight = dialog.getHeight();
		/* ------------------------------------------------------- */
		
		int bigger = finalWidth;
		
		
		// get the bigger number
		if (finalHeight >= finalWidth) {
			bigger  = finalHeight;
		} 
		/* ------------------------------------------------------- */
		dialog.setSize(0, 0);
		dialog.setVisible(true);
		int locX = 500;
		int locY = 500;
		dialog.setLocation(getCenterX(parent), getCenterX(parent));
		/* ------------------------------------------------------- */
		int curWidth = 0;
		int curHeight = 0;
		
		for (int i = 0; i <= bigger; i++) {
			/* ------------------------------------------------------- */
			if (curWidth < finalWidth)
				curWidth++;
			if (curHeight < finalHeight)
				curHeight++;
			if (i % 2 == 0) {
				locX--;
				locY--;
				final int fLocX = locX;
				final int fLocY = locY;
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						dialog.setLocation(fLocX, fLocY);
					}
				});
			}
			final int fCurH = curHeight;
			final int fCurW = curWidth;
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					dialog.setSize(fCurW, fCurH);
				}
			});	
			/* ------------------------------------------------------- */
		}
		
		if (wasModal)
			dialog.setModal(true);
		/* ================================================== */
	}
	
	
	
	
	/**
	 * Obtains the parent frame of a Component.
	 * Can either be a JFrame or a JDialog.
	 * Important for modal dialogs.
	 * 
	 * @param comp
	 * @return
	 */
	public static Window getOwnerFrame(Component comp) {
		// get the parent dialog or frame
		// from the back through the thorax right in the eye
		Component currComp = comp;

		while (currComp != null) {
			if (currComp instanceof JDialog) {
				break;
			} else if (currComp instanceof JFrame) {
				break;
			} else
				currComp = currComp.getParent();
		}
		return (Window) currComp;
	}
	
	
	/**
	 * returns the height of the current monitor
	 * @return the height of the current monitor
	 */
	public static double getScreenHeight() {
		return Toolkit.getDefaultToolkit().getScreenSize().getHeight();
	}
	
	/**
	 * returns the width of the current monitor
	 * @return the width of the current monitor
	 */
	public static double getScreenWidth() {
		return Toolkit.getDefaultToolkit().getScreenSize().getWidth();
	}
	
	
	/**
	 * Sets a new parent component to the JDialog.
	 * Be aware, that we have to exchange the underlaying JDialog object.
	 * The returned JDialog will be a different object!
	 * 
	 * @param dialog
	 * @param parent
	 * @return
	 */
	public static JDialog reOwnDialog(JDialog dialog, Window parent) {
		/* ================================================== */
		JDialog d = null;
		if (parent instanceof JDialog)
			d = new JDialog((JDialog) parent, dialog.getTitle(), dialog.isModal());
		else if (parent instanceof JFrame)
			d = new JDialog((JFrame) parent, dialog.getTitle(), dialog.isModal());
		
		d.setContentPane(dialog.getContentPane());
		
		return d;
		/* ================================================== */
	}
	
	
}
