/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel;

//***************************************************************************
//* Interface Definition                                                    *
//***************************************************************************

/**
 * The TableFilter interface the method required to implement custom filters
 * to be used in conjunction with the FilterTableModel.
 * @author nico.mack@tudor.lu
 */

public interface TableFilter 
	{	
//---------------------------------------------------------------------------
/**
 * The accept method checks whether the specified value matches the criteria
 * defined by the filter.
 * @param p_Value specifies the value to be check for compliance or not.
 * @return <code>true</code> if instance of filter accepts the specified value,
 * i.e. the specified value match the criteria defined by the filter, 
 * <code>false</code> if filter rejects the specified value.
 */
//---------------------------------------------------------------------------
	
	abstract boolean accept (Object p_Value);
	
//---------------------------------------------------------------------------
/**
 * Depending on the nature of the filter, filter criteria may need to be
 * processed first. A good example are regular expression which need to be
 * compiled before they can be used. The compile method is the method of
 * choice to locate that kind of code.
 */
//---------------------------------------------------------------------------

	abstract void compile ();
	
//---------------------------------------------------------------------------
/**
 * Allows to check whether filter is ready to filter, i.e. ready to accept
 * values.
 * @return <code>true</code> if filter is ready to accept data, <code>false</code>
 * otherwise.
 */
//---------------------------------------------------------------------------
	
	abstract boolean isFiltering ();
	
//---------------------------------------------------------------------------
/**
 * Sets the filtering criteria for the filter.
 * @param p_FilterValue specifies the filtering criteria for the filter.
 */
//---------------------------------------------------------------------------
	
	abstract void setFilter (Object p_FilterValue);
	
//***************************************************************************
//* End of Interface														*
//***************************************************************************
	}
