/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.utils.renderer;

import java.awt.Component;

import javax.swing.JList;

import lu.tudor.santec.gecamed.core.gui.utils.DefaultComboBoxRenderer;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Renderer for translated content of comboboxes.
 * Use like this.
 * 
 * path to translation is
 * example.mytext
 * 
 * the elements of the combobox are 
 * one
 * two
 * three
 * 
 * create your translatrix file like this
 * example.mytext.one
 * example.mytext.two
 * example.mytext.three
 * 
 * @author martin.heinemann@tudor.lu
 * 25.03.2008
 * 15:25:37
 *
 *
 * @version
 * <br>$Log: TranslatrixComboboxRenderer.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:09  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-03-28 08:51:34  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class TranslatrixComboboxRenderer extends DefaultComboBoxRenderer {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String translatrixString;
	
	
	
	/**
	 * @param translatrixString String that represents the path to the translatrix element.
	 */
	public TranslatrixComboboxRenderer(String translatrixString) {
		/* ================================================== */
		this.translatrixString = translatrixString + ".";
		/* ================================================== */
	}



	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.utils.DefaultComboBoxRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
	 */
	@Override
	public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
		/* ====================================================== */
		return super.getListCellRendererComponent(list, Translatrix.getTranslationString(translatrixString+value), index, isSelected,
				cellHasFocus);
		/* ====================================================== */
	}
	
	
	
	

}
