/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;

import lu.tudor.santec.gecamed.core.gui.utils.GradientFactory;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class ButtonPanel extends JPanel
	{
	private JPanel		m_ButtonPanel;
	private JPanel		m_Header;
	private Component	m_Title;
	private JPanel		m_GradientPanel;
	
	/**
	  * 
	  */

//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	public static final int	c_ButtonSize = 34;
		
	private static final long serialVersionUID = 1L;

	private final static String c_Columns= "3dlu,left:pref:grow," +
										   "3dlu,right:pref,3dlu";
	
	private final static String c_Rows=    "center:max(34px;pref)";

	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public ButtonPanel ()
	{
	this.init (null);
	}
	
//---------------------------------------------------------------------------

public ButtonPanel (Color p_Color)
	{
	this.init (p_Color);
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

private void init (Color p_Color)
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;

	l_Constraints  	= new CellConstraints();
	l_Layout		= new FormLayout(c_Columns, c_Rows);
	
	this.setLayout(new BorderLayout());
	
	m_Header = new JPanel ();
	
	m_Header.setLayout (l_Layout); 
	m_Header.setOpaque(true);
	m_Header.setBackground(p_Color);
	
	JLabel	l_Title = new JLabel ();
	l_Title.setOpaque(false);
	l_Title.setText("");
	m_Title	= l_Title;
	
	m_ButtonPanel = new JPanel ();
	m_ButtonPanel.setLayout(new BoxLayout(m_ButtonPanel,BoxLayout.LINE_AXIS)); 
    m_ButtonPanel.setBorder(new EmptyBorder(2,2,2,2));	
    m_ButtonPanel.setOpaque (false);
    
    m_Header.add (m_Title,       l_Constraints.xywh (2, 1, 1, 1));
    m_Header.add (m_ButtonPanel, l_Constraints.xywh (4, 1, 1, 1));
     
    if (p_Color == null) 
    	{
    	m_GradientPanel = null;
    	this.add(m_Header,BorderLayout.CENTER);	
    	}
    else 
    	{
    	m_GradientPanel = GradientFactory.makeGradient (m_Header, p_Color, true);
    	this.add(m_GradientPanel,BorderLayout.CENTER);
    	}
	}

//---------------------------------------------------------------------------

public static void addEffect (final JButton p_Button) 
	{
	p_Button.setMargin (new java.awt.Insets(0, 0, 0, 0));
	p_Button.setFocusable (false);
	p_Button.setContentAreaFilled (false);
	p_Button.setBorderPainted (false);
	
	p_Button.addMouseListener (new MouseAdapter() 
		{
		@Override
		public void mouseEntered(MouseEvent e) 
			{
			p_Button.setBorderPainted(true);
			p_Button.setContentAreaFilled(true);
			}
		@Override
		public void mouseExited(MouseEvent e) 
			{
			p_Button.setBorderPainted(false);
			p_Button.setContentAreaFilled(false);
			}
		});
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public void addButton (JComponent p_Button) 
	{    	
	if (p_Button instanceof JButton) 
		{
		addEffect((JButton) p_Button);
		p_Button.setPreferredSize(new Dimension(c_ButtonSize,c_ButtonSize));
		}
    m_ButtonPanel.add(p_Button);
    m_ButtonPanel.validate();
    }

//---------------------------------------------------------------------------
/**
  * adds a button to the panels right buttonbar at the specified position
  * @param p_Button
  * @param p_Position
  */
//---------------------------------------------------------------------------

public void addButton(JComponent p_Button, int p_Position) 
	{
	if (p_Button instanceof JButton) 
		{
		addEffect((JButton) p_Button);
		p_Button.setPreferredSize(new Dimension(c_ButtonSize,c_ButtonSize));
		}
    m_ButtonPanel.add(p_Button,p_Position);
    m_ButtonPanel.validate();
    }

//---------------------------------------------------------------------------

public void addSeparator ()
    {
    m_ButtonPanel.add(Box.createHorizontalStrut(5));
    m_ButtonPanel.add(new JSeparator(SwingConstants.VERTICAL));
    m_ButtonPanel.add(Box.createHorizontalStrut(5));
   	}

//---------------------------------------------------------------------------

/**
  * add a seperator to the buttonbar at the spezified position
  * @param p_Position
  */
    
//---------------------------------------------------------------------------

public void addSeparator (int p_Position)
	{
   	m_ButtonPanel.add (Box.createHorizontalStrut(5));
   	m_ButtonPanel.add (new JSeparator(SwingConstants.VERTICAL),p_Position);
   	m_ButtonPanel.add (Box.createHorizontalStrut(5));
	}

//---------------------------------------------------------------------------

public void setColor (Color p_Color)
	{
    if (m_GradientPanel != null)
    	{
		this.remove(m_GradientPanel);
		m_GradientPanel = GradientFactory.makeGradient (m_Header, p_Color, true);
		this.add (m_GradientPanel,BorderLayout.CENTER);	
    	}
    else m_Header.setBackground(p_Color);
	}


public void setTitle (String text, Icon icon)
{
	if (m_Title instanceof JLabel)
	{
		((JLabel) m_Title).setText(text);
		((JLabel) m_Title).setIcon(icon);
	}
}


public void setTitle (Component p_Title)
{
	m_Title	= p_Title;
	m_Header.add(m_Title, new CellConstraints(2, 1));
}


public Component getTitle ()
{
	return m_Title;
}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
