/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;

import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellEditor;


/**
 * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class CheckBoxEditorField extends AbstractCellEditor implements TableCellEditor,
																	     ActionListener
    {
	private JCheckBox	m_Selected;

	private static final long serialVersionUID = 1L;
 	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public CheckBoxEditorField () 
    {
	super ();
		
	m_Selected = new JCheckBox ();
	m_Selected.setHorizontalAlignment(SwingConstants.CENTER);
	m_Selected.addActionListener(this);
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************


//***************************************************************************
//* Class Body		                                                       *
//***************************************************************************

//---------------------------------------------------------------------------

public Object getCellEditorValue() 
	{
	return m_Selected.isSelected();
	}

//---------------------------------------------------------------------------

public boolean shouldSelectCell ()
	{
	return false;
	}
//---------------------------------------------------------------------------

public boolean shouldSelectCell (EventObject p_Event)
	{
	return false;
	}

//---------------------------------------------------------------------------

public Component getTableCellEditorComponent(JTable p_Table, Object p_InitialValue, 
										  boolean p_IsSelected, int p_Row, int p_Column) 
	{	
	if (p_InitialValue instanceof Boolean)
		{
		m_Selected.setSelected((Boolean)p_InitialValue);
		}
	return m_Selected;
	}

//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent p_Event) 
	{
	if (p_Event.getSource()==m_Selected)
		{
		this.stopCellEditing();
		}
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}

