/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * Author: Johannes Hermen Tudor/Santec
 * Mail: johannes.hermen@tudor.lu
 * Created: Jun 15, 2005
 *
 */
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.Dimension;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;


/**
 * @author Johannes Hermen johannes.hermen(at)tudor.lu Tudor/Santec
 *
 */
public class FileChooserPreview extends JLabel implements PropertyChangeListener
{
    //~ Static fields/initializers =============================================

	private static final long serialVersionUID = 1L;

	private static SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");

    //~ Instance fields ========================================================

    File file = null;
    ImageIcon thumbnail = null;
    String info = "";

    //~ Constructors ===========================================================

    public FileChooserPreview(JFileChooser fc)
    {
        setPreferredSize(new Dimension(100, 70));
        this.setBorder(new TitledBorder("Preview:"));
        fc.addPropertyChangeListener(this);
    }

    //~ Methods ================================================================

    public void loadImage()
    {
        if (file == null) {
            thumbnail = null;
            info = "";
            return;
        }
        ImageIcon tmpIcon = new ImageIcon(file.getPath());
        if ((tmpIcon != null) && (tmpIcon.getIconWidth() > 1)) {
            if (tmpIcon.getIconWidth() > 90) {
                thumbnail = new ImageIcon(tmpIcon.getImage().getScaledInstance(90,
                            -1, Image.SCALE_DEFAULT));
            } else { //no need to miniaturize
                thumbnail = tmpIcon;
            }
        } else {
            info = "<html>Date:<br>" +
                df.format(new Date(file.lastModified())) + "<br>Size:<br>" +
                (file.length() / 1024) + "kb </html>";
        }
    }

    public void propertyChange(PropertyChangeEvent e)
    {
        boolean update = false;
        String prop = e.getPropertyName();

        //If the directory changed, don't show an image.
        if (JFileChooser.DIRECTORY_CHANGED_PROPERTY.equals(prop)) {
            file = null;
            update = true;

            //If a file became selected, find out which one.
        } else if (JFileChooser.SELECTED_FILE_CHANGED_PROPERTY.equals(prop)) {
            file = (File) e.getNewValue();
            update = true;
        }

        //Update the preview accordingly.
        if (update) {
            thumbnail = null;
            if (isShowing()) {
                loadImage();
                setPreview();
            }
        }
    }

    private void setPreview()
    {
        if ((thumbnail != null) && (thumbnail.getIconWidth() > 1)) {
            this.setVerticalAlignment(JLabel.CENTER);
            this.setText("");
            this.setIcon(thumbnail);
        } else {
            this.setVerticalAlignment(JLabel.TOP);
            this.setIcon(null);
            this.setText(info);
        }
    }
}
