package lu.tudor.santec.gecamed.core.gui.widgets;

/**
 * @author santec
 * 
 * Used from the GECAMedBaseDialog to define what happens, if an predefined action is called.
 */
public interface GECAMedDialogActionListener {
	
	/**
	 * Called if, in a GECAMedBaseDialog, the OK button is pressed or the ENTER key is hit.
	 */
	public void okActionCalled ();

	/**
	 * Called if, in a GECAMedBaseDialog, the cancel button is pressed or the ESC key is hit.
	 */
	public void cancelActionCalled ();

	/**
	 * Called if, in a GECAMedBaseDialog, the apply button is pressed.
	 */
	public void applyActionCalled ();

	/**
	 * Called if, in a GECAMedBaseDialog, the yes button is pressed or the ENTER key is hit.
	 */
	public void yesActionCalled ();

	/**
	 * Called if, in a GECAMedBaseDialog, the no button is pressed.
	 */
	public void noActionCalled ();

	/**
	 * Called if, in a GECAMedBaseDialog, the red cross to close the dialog is pressed.
	 */
	public void closeActionCalled ();
	
	/**
	 * Called when the dialog is opened
	 */
	public void prepareToShowUp ();
}
