/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.IOException;

import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class HTMLDialog extends JDialog implements HyperlinkListener {
	
	/**
	 * static logger for this class
	 */
	private static Logger logger = Logger.getLogger(HTMLDialog.class.getName());
	
	private static final long serialVersionUID = 1L;
	private JEditorPane htmlPane;

    public HTMLDialog(String title, String url) 
    {

	htmlPane = new JEditorPane();
	htmlPane.setContentType("text/html");
	htmlPane.setEditable(false);
	htmlPane.addHyperlinkListener(this);

	try {
		htmlPane.setPage(url);
	} catch (IOException e) {
		logger.log(Level.WARN, "html display failed", e);
	}

	JScrollPane jsp = new JScrollPane(htmlPane);
	jsp.setPreferredSize(new Dimension(400, 400));

        setTitle(title);
        setLayout(new BorderLayout());
		add(jsp, BorderLayout.CENTER);
        pack();
        
        setVisible(true);
    }

	public void hyperlinkUpdate(HyperlinkEvent e) {
		if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
			JEditorPane pane = (JEditorPane)e.getSource();
			if (e instanceof HTMLFrameHyperlinkEvent) {
			    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
			    HTMLDocument doc = (HTMLDocument)pane.getDocument();
			    doc.processHTMLFrameHyperlinkEvent(evt);
			}
			else {
			    try {
				pane.setPage(e.getURL());
			    }
			    catch (Throwable t) {
			    }
			}
		    }
	}

}
